// fit the height of a window (or container) content.
// April 2022
// This is a "beta" version. It has been tested and mostly works, but not well enough to be dependable.
// For a less powerful, but more reliable, alternative:  see wsurvey.fitToParent (in wsurvey.utils1.js)
//
// -=================================================
// It might be useful in some applications, but there are enough cases where it just doesn't do what one
// would hope for.
// It is doubtful that I will try to develop this -- how jquery and css work together to define and specify heights
// has too many quirks.

//  Basics:
//   THe goal is to tweak the contents of a window, or of a specified contianer, so that no "external" scroll bar
//   is needed. Or, only a small amount of scrolling is needed. This means that scrolling will occur on each
//   specified element in a childlist.
//  THis can be useful if you have several vertical containers, that may have one or several potentially scrollable
//  elements. The use can then scroll each one on as needed basis, rather than scrolling the entire window just
//  to view the off-screen stuff in one container.
//
// Technically: this uses iterative adjusts the height of elements specified in "childList", so that
//               the "scrollHeight" of the "atarget" is the same (or close to) its height
//               THUS: only elements in childList are worked with. All other children of atarget0 are left as is
//
//    res=wsurvey.fitContent=function(atarget0,childList,opts0);
// where
//   atarget0 : either False, or a jquery selector pointing to on container.
//               If false, use the entire window
//   childList : an array, each element is a jquery selector (such as '#myChild1"). These should be children
//            of the atarget0 -- NOT grandchildren. If a selector is NOT a child,  it is ignored
//             See below for an alternative specification
//   opts0: options (optional)
//      tolFit    -- how close a fit. I.e;  10 means "stop the iteration if the result is within 10px.
//                  You can also specify  'xxem' (for ems).Default is 2px
//      minHeight  -- the minimum that an element in childList can be shrunk to. Same specs as tolFit. Default is 3em
//      targetheight     -- height to match. If specified, this over rides the "atarget0" height. This is NOT well tested
//                      Default is false (use the atarget0.height)
//      maxIter    -- maximum iterations. Default is 400. Used to prevent infinite loops (which should rarely occur)
//      verbose    -- returns a "messages" array that contains status messages. Can be long.  Default is false
//      stringent   -- if any element in childList can not be found, return with an error. Default is false
//
// Returns:  [status,mesages]
//    If verbose=0, messages will be short
//    status is a 3 element array
//  If status[0]===false : [false,0,note] -- the note is a one word description of the error
//    Examples of note: someChildrenMissing, allChildrenMissing
//  Otherwise:  [thisStatus,iters,hdiff]
//    iters is # of iterations,
//     hdiff is the difference between desired (atarget.height or targetHeight) and  the scrollHeight of atarget0
//    thisStatus can be:
//      ok -- succesful adjusment
//      partial  -- unable to adjust, since all childList elements are at their minHeight
//      maxiter   -- unable to adjust, maxIter iterations were performed
//
// Special feature (not well tested)
//   Each element of childList is usually a jQuery selector (a string or ajQuery objects)
//   However, it can be a 2 element array of [jQUerySelector,minHeight]
//   This minHeight will override the global minHeight (for this child element)

if (typeof(wsurvey)=='undefined')  {
    var wsurvey={};
}



//==================
// shrink selected "children" of a target (window or a container), so that
// the target (window or container) does not need scroll vars

wsurvey.fitContent=function(atarget0,childList,opts0) {

  var theScroll,theHeight,useBox,mess=[],elistDo=[];
  var targetTypeSay,verbose=0,emSize,useBox,atarget;

  emSize=parseInt(jQuery("body").css('font-size'));
  var  opts={'tolFit':'2','minHeight':3*emSize,'maxIter':400,'stringent':false,
              'verbose':false,'targetHeight':false};             // the defaults (changed in initOpts)

// fix function arguments
  if (arguments.length<2) {
     mess.push('Error: you must specify a target and a list ');
     let aa=[false,0,'bad arguments'];
     return [aa,mess] ;
  }
  if (arguments.length<3) opts0={} ;
  atarget=atarget0 ;
  if (atarget0==0) atarget=false ;
  if (typeof(atarget)=='string' && jQuery.trim(atarget)=='') atarget=false;

  initOpts(opts0);  // changes the opts "global"

// check that target is valid, and that childList is valid
  let qdo;
  if (atarget==false) {          // fit    window
     qdo=initTargetWindow(1);    // sets theScroll, theHeight, elistDo, targetTypeSay, and useBox

  } else {                          // fit to a container
     qdo=initTargetElement(1);
  }
  if (qdo!==true) return [qdo,mess];     // somke kind of problem

  verbose=opts['verbose'] ;

  if (verbose) mess.push(targetTypeSay);
  if (verbose) mess.push('Options: tolFit='+opts['tolFit']+', minHeight='+opts['minHeight']+', maxIter='+opts['maxIter']);
  if (atarget===false) {
     if (verbose) mess.push('Starting values: screen height='+theHeight+', document height='+theScroll);
  } else {
     if (verbose) mess.push('Starting values: container ('+atargetSay+') -- height='+theHeight+', scrollHeight='+theScroll);
  }

// note: theHeight will never change. theScroll will change as childList elements are tweaked
  let hdiff=theScroll -theHeight ;        // + values means shrink stuff in childList , - means expand

 if (hdiff>0)  {    // need to shrink elements in childList
    stuff= doShrink(1);
    return [stuff,mess];

  } else {         // expand the elements in childList!
     stuff= doExpand(1);
     return [stuff,mess];
  }
  return false;

//  ------------
// these internal functions use variables set in the parent function
// note: theHeight never changes -- it is the height of the window, or of the "parent" container
//        theScroll does change -- is is the "document" height, or the scrollHeight of the container
//        Note that the total height of childList (actually, elistdo) is <= this scroll heignt, since there may
//        be elements in the parent that are NOT specified in childList.

   // ---------
// target is browser window ... check some stuff
  function initTargetWindow(xx) {
     theScroll=getMyScroll(atarget);
     let aMinHeight=opts['minHeight'];

     noMatches=0;
     let theHeightW=$(window).height();
     if (opts['targetHeight']===false) {
        theHeight=theHeightW
     } else {
        theHeight=wsurvey.toPx(opts['targetHeight'],theHeightW,emSize);
     }

     for  (let  ic=0;ic<childList.length;ic++) {
         let c1X=childList[ic];     // could be   ['id',minheight, ['id'], or 'id'
          minThisHeight=aMinHeight ;
         if (typeof(c1X)=='array')  {
              c1=c1X[0];
              if (c1X.length>1)  minThisHeight=wsurvey.toPx(c1X[1],theHeight,emSize);
         }   else {
            c1=c1X ;
         }
         if (isNaN(minThisHeight || minThisHeight<1)) minThisHeight=2*emSize ; // 2px if goofy

         let c1Say =  (typeof(c1)=='string') ? ic+' ('+c1+')' : ic + ' (...)' ;

         let e1=$(document.body).children(c1);

         if (e1.length==0) {
            mess.push(c1+' No match for element (not a child of document.body): '+ c1Say );
            noMatches++;
            continue;
         }
         for   (let ie2=0;ie2<e1.length;ie2++)  {
           e1B=$(e1[ie2]);
           let c1Say =  (typeof(c1)=='string') ? ic+'/'+ie2+' ('+c1+')' : ic+ '/'+ie2 + ' (...)' ;
           let e1BHeight=e1B.height();
           if (e1BHeight<minThisHeight) continue  ; // ignore if too small
           let a1=[e1B,c1Say,e1BHeight,minThisHeight];
           elistDo.push(a1)
         }
     }
     if (elistDo.length==0) {
        mess.push('None of the '+childList.length+' listed elements were in the document.body ');
        return [false,0,'allChildrenMissing'];
     }
     if (opts['stringent'] && noMatches>0) {
        mess.push('Stringent mode: one or more childList elements not found.');
        return [false,0,'someChildrenMissing'];
     }
     targetTypeSay='Fitting to browser window ';
     return true;
  }   //initTargetWindow

// ---- target is an eelement ... check some stuff
  function initTargetElement(xx) {

     let noMatches=0;
     let aMinHeight=opts['minHeight'];
     atargetSay= (typeof(atarget)=='string') ? atarget : ' element ...';

     useBox=$(atarget);              // useBox and atargetSay are "global" (scope is  parent function)
     if (useBox.length==0) {
        mess.push('No such target (to have content) '+atargetSay);
        return [false,0,'noSuchTarget'] ;
     }
     let targetHeightC=useBox.height();
     if (opts['targetHeight']===false) {
        theHeight=targetHeightC ;
     } else {
        theHeight=wsurvey.toPx(opts['targetHeight'],targetHeightC,emSize)
     }
     theScroll=getMyScroll(atarget);

     for  (let ic=0;ic<childList.length;ic++) {
         let c1X=childList[ic];     // could be   ['id',minheight, ['id'], or 'id'
         minThisHeight=aMinHeight ;
         if (typeof(c1X)=='array')  {
              c1=c1X[0];
              if (c1X.length>1)  minThisHeight=wsurvey.toPx(c1X[1],theHeight,emSize);
         }   else {
            c1=c1X ;
         }
         if (isNaN(minThisHeight || minThisHeight<1)) minThisHeight=2*emSize ; // 2px if goofy
         let c1Say =  (typeof(c1)=='string') ? ic+' ('+c1+')' : ic + ' (...)' ;

         let e1=useBox.children(c1);

         if (e1.length==0) {
            mess.push('No match for element: '+ c1Say );
            noMatches++;
            continue;
         }
         for   (let ie2=0;ie2<e1.length;ie2++)  {
           e1B=$(e1[ie2]);
           let c1Say =  (typeof(c1)=='string') ? ic+'/'+ie2+' ('+c1+')' : ic+ '/'+ie2 + ' (...)' ;
            let e1BHeight=e1B.height();
           if (e1BHeight<minThisHeight) continue  ; // ignore if too small
           let a1=[e1B,c1Say,e1BHeight,minThisHeight] ;
           elistDo.push(a1)
         }
  //      e1.css({'background-color':'yellow'});
     }
     if (elistDo.length==0) {
        mess.push('None of the '+childList.length+' elements were children in the container  ('+atargetSay+')');
        return [false,0,'allChildrenMissing'];
     }
     if (opts['stringent'] && noMatches>0) {
        mess.push('Stringent mode: please fix the childElements list');
        return [false,0,'someChildrenMissing'];
     }

     targetTypeSay='Fitting to container in document: '+atargetSay ;
     return true;
 }     //   initTargetElement

//-------
// initialize the options (use defaults if not specified)
// read values of the options
  function initOpts(opts0)  {
    for (let aopt0 in opts0) {
        let aval=opts0[aopt0];
        let aopt=jQuery.trim(aopt0).toLowerCase();
        if (aopt=='tolfit')  {
             let ipx=wsurvey.toPx(aval,'h',emSize);
             if (!isNaN(ipx)) opts['tolFit']=ipx;
        }
        if (aopt=='minheight')  {
             let ipx=wsurvey.toPx(aval,'h',emSize);
             if (!isNaN(ipx)) opts['minHeight']=ipx;
        }
        if (aopt=='height' || aopt=='targetheight' )  {
           if (typeof(aval)!=='undefined') {
             let ipx=wsurvey.toPx(aval,'h',emSize);
             if (!isNaN(ipx)) opts['targetHeight']=ipx;
           }
        }

        if (aopt=='maxiter') {
           if (!isNaN(aval) && parseInt(aval)>0) opts['maxIter']=parseInt(aval);
        }
        if (aopt=='verbose') {
            if (jQuery.trim(aval)=='1' || aval===true) opts['verbose']=true;
        }
        if (aopt=='stringent') {
            if (jQuery.trim(aval)=='1' || aval===true ) opts['stringent']=true;
        }

    }   // done reading options
    return 1 ;
  }        // initOpts


// ---
 //============
// change sizes -- shrink mode
  function doShrink(ido)   {       // ::::::::::: SHRINK elistDo  ::::

    let theScroll2=getMyScroll(atarget);
    let tolFit=opts['tolFit'];
    let minHeight=opts['minHeight'];
    let maxIter=opts['maxIter'];

    if (ido==2) {
        if (verbose) mess.push('Shrink (after expand) from '+theScroll2+' toward '+theHeight);
    } else {
        if (verbose) mess.push('Shrink from '+theScroll2+' toward '+theHeight);
    }
    if (verbose) mess.push('Iter 1: # elements to adjust= '+elistDo.length+' ... by '+emSize);

// first iteration ...
    let ndid=0,totHeightE=0,heightE=[];
    let eSkip=[];
    for (let j=0;j<elistDo.length;j++) {
       let edo=elistDo[j][0];
       let cSay=elistDo[j][1];
       aheightElem=elistDo[j][2];
       let aminHeight=elistDo[j][3];
       eSkip[j]=false;

       heightE[j]=0      ;         //  init to 0 to deal with too smalls to boether

       let aheightElemNew=aheightElem  - emSize ;
       if (aheightElemNew<aminHeight)  {
           eSkip[j]=true ;       // ignore this in later iterations
           if (verbose) mess.push(cSay+' can not be changed from '+aheightElem+' to '+aheightElemNew);
           continue ;  // don't make this any smaller
       }

       totHeightE+=aheightElem;        // used to figure fraction of this elments height (of height of all  "changable elements"
       heightE[j]=aheightElem      ;         // e fractions (thisHeight / allChildListHeights).

       if (verbose) mess.push(cSay+' from '+aheightElem+'  to '+aheightElemNew);

       edo.height(aheightElemNew);                // change them both ...
       edo.css({'height':aheightElemNew});
       elistDo[j][2]=aheightElemNew;
       ndid++;

       theScroll2=getMyScroll(atarget);   // to be sure, get actual scroll height AFTER this change.
       let heightDiffNew=Math.abs(theScroll2-theHeight) ;
       if (heightDiffNew<tolFit) {        // got it!
          if (ido==1) {
             mess.push('Shrink done: scollHeight='+ theScroll2);
          } else {
             mess.push('Expand done: scollHeight='+ theScroll2);
          }
          return ['ok',1 ,heightDiffNew] ;
       }
    }        // done with first iteration

    if (ndid==0)  {    // no valid elements, or they are all too small to shrink
        let theScroll3=getMyScroll(atarget)  ;  // to be sure, get actual scrollheight again
        let hdiff2=Math.abs(theScroll3-theHeight) ;
        if (verbose) mess.push('Problem after iter 1 all '+elistDo.length+' elements are at minHeight)');
        mess.push('Shrink stopped: scrollHeight='+ theScroll3);
        return ['partial',1,hdiff2];
    }

    for (let k1=0;k1<heightE.length;k1++) {   // convert each elist height  into fraction of all elist heights
         heightE[k1]=heightE[k1]/totHeightE;
    }

// more shrink iterations!
    for (let niters=2;niters<maxIter;niters++) {   // keep trying ...  using steps that depend on hdiff and on elem height
      let hdiff=Math.abs(theScroll2-theHeight);
      if (verbose) mess.push('Start '+niters+' @ '+theScroll2 +' ... by '+hdiff);
      let ndid=0;

      for (let icc in elistDo) {
          if (eSkip[icc]) continue ;       // marked as already too small?

          let aedo=elistDo[icc][0];
          let cSay=elistDo[icc][1];
          let aedoHeight=elistDo[icc][2];
          let aedoMinHeight=elistDo[icc][3];

          let changeBy=(heightE[icc]*hdiff)/2  ;     // half steps...
          let aedoHeightNew=(aedoHeight - (changeBy)) ;

          if (aedoHeightNew<aedoMinHeight)  {
               eSkip[icc]=true;
               if (verbose) mess.push(cSay+' can not be changed from '+aedoHeight+' to '+aedoHeightNew);
               continue ;      // don't make this any smaller
          }
          aedo.height(aedoHeightNew);                // change them both ...
          aedo.css({'height':aedoHeightNew});
          elistDo[icc][2]=aedoHeightNew;
          ndid++;
          if (verbose) mess.push(cSay+' from '+aedoHeight+' to ' + aedoHeightNew+' ... frac='+heightE[icc].toFixed(3));

          theScroll2=getMyScroll(atarget)    ;  // to be sure, get actual height (Rather than use math)
          let heightDiffNew=Math.abs(theScroll2-theHeight) ;
          if (heightDiffNew<tolFit) {
             mess.push('Shrink done: scollHeight='+ theScroll2);
             return ['ok,',niters,heightDiffNew] ;
          }
      }

      if (ndid==0) {
        let theScroll3=getMyScroll(atarget);
        let heightDiffNew=Math.abs(theScroll3-theHeight) ;
         mess.push('Problem after '+niters+':  all elements are small -- unable to make further changes. Final scrollHeight='+getMyScroll );
         return ['partial',niters,heightDiffNew] ;
      }
    }           // iter  -- and do more changes (if done, exit via return in the body of the loop)

    let theScroll3=getMyScroll(atarget);
    let hdiff2=Math.abs(theScroll3-theHeight) ;     // getting here would be odd... but could happen
    mess.push('Problem: after maxIters ('+maxIter+') -- heightDiff still too big ('+hdiff2+')');
    return ['maxiter',maxIter,hdiff2] ;

  }    // doShrink


//=========
// expand, then shrink

function doExpand(ido) {
    let tHeight=20;
    for (let it1=0;it1<elistDo.length;it1++) tHeight+=elistDo[it1][2];
    let fracs=[];
    for (let it1=0;it1<elistDo.length;it1++) fracs[it1]=elistDo[it1][2]/tHeight ;
    fixedSize=theHeight-tHeight

    for (let ii=1;ii<10;ii++) {
      if (verbose)  mess.push('Expand, iter '+ii+', using '+fixedSize);
      for (let it1=0;it1<elistDo.length;it1++) {
        let aedo=elistDo[it1][0];            // [e1B,c1Say,e1BHeight,minThisHeight];
        let wasSize=elistDo[it1][2]  ;
        let inc1=fixedSize*fracs[it1];
        let newSize=wasSize+inc1;
        aedo.height(newSize);                // change them both ...
        aedo.css({'height':newSize});
        elistDo[it1][2]=newSize;
      }
      let scSize=getMyScroll(atarget);
      if (verbose)  mess.push(' After expand iter '+ii+': '+scSize);
      if (scSize>theHeight) break ;

    }
    if (verbose)  mess.push(' Expand done, shrink to fit ');
    let scSize2=getMyScroll(atarget);
    let foo=doShrink(2);
    return foo ;
  }


//===========
// return scroll height. Either $(document).height() or useBox[0].scrollHeight (depending on value of atarget
  // could use atarget global, but requiring an argument gives some flexiblity
function getMyScroll(btarget) {
    if (btarget===false)  {  // window
      return parseInt($(document).height());
    } else {
      return parseInt(useBox[0].scrollHeight);
    }
  }

}    // wsurvey.fitContent.shrink
