<?php
namespace wsurvey\uploadFiles ;


// PHP handler for files uploaded use wsurvey.uploadFiles.js
//
// retrieve file upload stuff created by wsurvey.uploadFiles.js functions
// returns in array, each row is associative array containing file info in fields: fileName,fileType,fileDate,fileSize,fileContent,
// expects the stuff sent by wsurvey.uploadFiles .send or .echoBack.
// By default, unpack into an object. If unpack=0, send the "crlf seperated long string"

function retrieve($unpack=1 ) {

    $attachContentName='wsurveyUploadFiles_data' ;
     $attachStuff=[]  ;              // uploaded files stored here. each row is an array with fields: filename,type,moddate,size,and content
    $attachContent=extractRequestVar($attachContentName) ;
    if ($unpack==0) return $attachContent ;

     if (trim($attachContent)!=='') {
        $alines=explode("\n",$attachContent);
        for ($jj=0;$jj<count($alines);$jj++) {
          if ($alines[$jj]=='') continue ;
          $goo=explode( ',',$alines[$jj]) ;

          if (count($goo)<3) continue ;             // note that descriptive info is uriencoded

          $crc32Js=$goo[0] ;            // a simple integrity check
          $attachName=rawurldecode($goo[1])  ;
          $attachType=rawurldecode($goo[2]);         // 3 is size, but use strlen instead
          $attachModDate=rawurldecode($goo[4]);    // [4] is encoding information that is not used
          $attachData=base64_decode($goo[6]);      // note that content is base64 encoded
          $isEncoded=$goo[7];
          if ($isEncoded==1) $attachData=rawurldecode($attachData);
          $acomment=rawurldecode($goo[8]);      // note that content is base64 encoded

          $goox=array_slice($goo,1);
          $goox2=trim(implode(',',$goox));  // get rid of stray crlfs
          $crc32_now=crc32($goox2);
          if ($crc32_now!=$crc32Js) {
              print "Error: crc32 supplied by client ($crc32Js) does not match crc32 of recieved content ($crc32_now):   $attachName ";
              exit ;
          }

          // and you can then save it for later use ...
            $r1=array('fileContent'=>$attachData,'fileName'=>$attachName,'fileType'=>$attachType,'fileDate'=>$attachModDate,'fileSize'=>strlen($attachData),'comment'=>$acomment);
          $attachStuff[]=$r1   ;
         }
     }
     return $attachStuff ;
 }


//=====================
// echoback a file or files (as uploaded using uploadFile.echoBack
// whidfile: if sevefal files uplaoddd, which to echoback
//  whidhFile=0 : all of them, in a .zip file
// Otherwise if >0: the ith file (starting at 1). If whichFile> number of files uploaded, return the last one
// if just one file uploaded, whichFile is ignored

function echoBack($whichFile=0 ) {
     ob_clean();

     if (!is_numeric($whichFile)) $whichFile=0;
     $astuff0=retrieve(1);
 
     if (count($astuff0)==0)  {
          echo "echoBack: No files specified ";
          exit;
     }

     if (count($astuff0)==1) {  // send file back using its content-tyem
       $astuff=$astuff0[0];
       $cont1=$astuff['fileContent'];     // decoded
       $mtype=$astuff['fileType'];
       header('Content-type: '.$mtype);
       header("Content-Length: " . strlen($cont1));
       header('Expires: 0');
       $filename=trim($astuff['fileName']);
       if ($filename!='')  header('Content-Disposition: attachment; filename='. urlencode($filename));
       echo $cont1;
       exit;
     }


// > 1 file.... send as zip file? or select one of them
    if ($whichFile>0) {
       if ($whichFile>count($astuff0)) $whichFile=count($astuff0);
       if ($whichFile<0) $whichFile=1;
       $iuse=$whichFile-1  ;  // since arrays start at 0
       $astuff=$astuff0[$iuse];
       $cont1=$astuff['fileContent'];     // decoded
       $mtype=$astuff['fileType'];
       header('Content-type: '.$mtype);
       header("Content-Length: " . strlen($cont1));
       header('Expires: 0');
       $filename=trim($astuff['fileName']);
       if ($filename!='')  header('Content-Disposition: attachment; filename='. urlencode($filename));
       echo $cont1;
       exit;
     }


// if here, return as zip  (0 or <0)

    if (!extension_loaded('zip'))  {
        echo "ZIP file creation not supported -- unable to return multiple files";
        exit;
    }
    $tname=tempnam(sys_get_temp_dir(), "uploads");

   $zip = new \ZipArchive(); // Load zip library

    $res=$zip->open($tname, \ZIPARCHIVE::CREATE);
    if ($res!==TRUE) {
        echo "ZIP creation failed at this time-- unable to return multiple files";
        exit;
    }

    foreach($astuff0 as $ijj=>$afile)  {
       $afilename=$afile['fileName'];
       $atype=$afile['fileType'];
       $adate=$afile['fileDate'];
       $acomment=$afile['comment'];
       $asize=$afile['fileSize'];
       $acomment="type: $atype, date=$adate, size=$asize, comment=$acomment";
        $cont1=$afile['fileContent'];
        $zip->addFromString($afilename,$cont1); // Adding files into zip
       $zip->setCommentName($afilename,$acomment); // Adding comment
    }
    $amess2='Created from '.count($astuff0).' files uploaded on '.date("Y-m-d H:i:s")  ;
    $zip->setArchiveComment($amess2);
    $zip->close();
    header('Content-type: application/zip');
     header('Content-Disposition: attachment; filename="'.$tname.'"');
    readfile($tname);
    unlink($tname);
}
//===-
// extract a request field (GET or POST)
// varname is name of field to get. can be a space delimited list of names (first one found is returned)
// if $errormess='', return $default if no such field
//    if = '1',  display generic error  message and exit
//    else, display $errormess and exit
function extractRequestVar($varname,$default='0',$errorMess='') {
$varname=trim(strtoupper($varname));
$vars =getWords($varname);

foreach ($_REQUEST as $vname=>$oof) {
     $avar=trim(strtoupper($vname)) ;
     for ($ith=0;$ith<count($vars);$ith++) {
        if ($avar==$vars[$ith]) {
           return $oof ;
        }
     }
}
// if here, could not be found

$errorMess=trim($errorMess);
if ($errorMess!=='') {          // an error, quit      -- sep 2014 note: on too large file uploads, you might get this error (buffer overwrite?)
  if ($errorMess=='1') {
     $file = $_SERVER["SCRIPT_NAME"];
      $break = explode('/', $file);
      $pfile = $break[count($break) - 1];
      print "\n";
      print '- Error. not able to find request variable (' . $varname . ') in ' . $pfile ;
      if (count($_REQUEST)==0) {
         print '   <br>Note: the $_REQUEST parameter is empty. This is often a sign of an upload that exceeds server limits. '  ;
      }
  } else {
     header("Content-Type: text/plain");
     print $errorMess ;
  }
  exit ;
}

 return $default ;
}

//=============
// trim spaces, convert internal spaces to single space string, break into an array
// if docomma=1, treat commas and tabs and new lines as spaces
function getWords($cval3,$docomma=0) {
    $cval3=trim($cval3);
    if ($docomma==1) {
      $cval4=preg_replace("/[\t\n\r\s,]+/"," ", $cval3) ;             // collapse spaces and other seperators
    } else {
      $cval4=preg_replace("/\s+/"," ", $cval3) ;             // collapse spaces
    }
    $bvars=explode(' ',$cval4) ;
    return $bvars ;

}

//===============
// check for overlow (content-length > postMaxsize 
function checkOverflow($kill) {
  if (!isset($_SERVER['CONTENT_LENGTH'])) return false ; // no content length, so no overflow (ignore huge GETS)
  $cLen=$_SERVER['CONTENT_LENGTH'] ;
  $postMaxSize= getBytes(ini_get('post_max_size'))  ;
  if (($cLen*1.01)<$postMaxSize) return false;
  if ($kill!=1)  return true;     // add a bit for overhad
  print "Sorry: the size of the request is too large: $cLen > $postMaxSize ";
  exit;
}



//===============
// returns a string suitable for writing to <script>, that lists globals for memory limits
function readSizeLimits($doPrint) {
  $memLimit= getBytes(ini_get('memory_limit'));
  $postMaxSize= getBytes(ini_get('post_max_size'))  ;
  $upload_max_filesize= getBytes(ini_get('upload_max_filesize')) ;
  $amess="\n";
  $amess.="// server limits as of  ". date("Y-m-d H:i:s") ." ;\n" ;
  $amess.="var wsurvey_uploadFiles_memory_limit=$memLimit ; \n"  ;
  $amess.="var wsurvey_uploadFiles_post_max_size=$postMaxSize ;\n"   ;
  $amess.="var wsurvey_uploadFiles_upload_max_filesize=$upload_max_filesize ; \n" ;
  if ($doPrint==1) print $amess;

  return $amess;
}

// ================
// takes a value from ini_get(), and converts to an integer (i.e.; 8M becomes 8388608)
 function getBytes($val) {
    $val = trim($val);
    preg_match('/([0-9]+)[\s]*([a-zA-Z]+)/', $val, $matches);
    $value = (isset($matches[1])) ? intval($matches[1]) : 0;
    $metric = (isset($matches[2])) ? strtolower($matches[2]) : 'b';
    switch ($metric) {
        case 'tb':
        case 't':
            $value *= 1024;
        case 'gb':
        case 'g':
            $value *= 1024;
        case 'mb':
        case 'm':
            $value *= 1024;
        case 'kb':
        case 'k':
            $value *= 1024;
    }
    return $value;
}
?>
