<?php
namespace wSurvey\getJson ;

//=====================
//  For details, see wsurvey.getJson.txt (in the wsurvey/jsLib
//
// In php callers, include a line like
//     use wSurvey\getgJson as getJs
// and then call these using
//  getJs/jsonReturn()
//
// functions to do ajax responses.
// WOrks with wsurvey.getJson.js!

// === returns a variable from $_REQUEST. Or the default
// if varname is a delimited list (space, comma, tab) -- search for each word until match is found
// this is basically extractRequestVar
function readVar($varname,$adef=false) {
  $varname=trim(strtoupper($varname));

  $cval3=trim($varname);   // getwords
  $cval4=preg_replace("/[\t\n\r\s,]+/"," ", $cval3) ;             // collapse spaces and other seperators
  $vars=explode(' ',$cval4) ;

  foreach ($_REQUEST as $vname=>$oof) {
     $avar=trim(strtoupper($vname)) ;
     for ($ith=0;$ith<count($vars);$ith++) {
        if ($avar==$vars[$ith]) {
           return $oof ;
        }
     }
  }
// if here, could not be found
 return $adef ;
}
 


//====================
// returns a json'ized array  (Larray) to the client.
// printOkay (by default 0) = 1 means that anything in the output buffer is added to a 'print' field
//     The default (0) means a non-empty buffer means an error occurred. 'print' is created AND status='error' is used
//  Tpyically, a 'content' field is Lstatus, but it is not required


function  jsonReturn($Lstatus=['status'=>0,'content'=>''],$printOkay=0) {
   if (array_key_exists('status',$Lstatus)) {
//      if ($Lstatus['status']=='error') {
//          $_SESSION['wsGallery_errors'][]=$Lstatus['content'];
//      }
   }
//   if (array_key_exists('error',$Lstatus) && $Lstatus['error']!='')  {
//         $_SESSION['wsGallery_errors'][]=$Lstatus['error'] ;
//   }

   $pout=trim(ob_get_contents());
   $printOkay=trim($printOkay);
   $Lstatus['print']=$pout;
   if ($pout!=='') {
       if ($printOkay!='1') $Lstatus['status']='error';   // the default is to assume anything printed (or echoed) is a php error
   }
   ob_end_clean();
   header('Content-type: application/json');
   echo json_encode($Lstatus);
   exit;
}
 
//======================
// returns a json'ized array : using content as the 'content' field (status='ok')
//  Tpyically, a 'content' field is Lstatus, but it is not required
// note: assumes anything in output buffer (print or echo) is an error (status set to error, 'print' field contains the  output buffer
function  jsonReturnContent($acontent) {
  $infos=['status'=>'ok','content'=>$acontent,'print'=>''];

   $pout=trim(ob_get_contents());
   $infos['print']=trim($pout);
   if ($pout!=='') {
         $infos['status']='error';   // the default is to assume anything printed (or echoed) is a php error
         $infos['print']=$pout;
   }
   ob_end_clean();
   header('Content-type: application/json');
   echo json_encode($infos);
   exit;
}
 

//====================
// return an object with an status='error' field, and other fields, for error handling by .js invokers
// acontent and othercontent can be associative arrays.
//  Returns a "json'ized' array with fields:
//       status='error',
//  and  content=acontent,
//      otherContent,
//  and  
//      print=outputBuffer,
//      backTrace=listOfCallerFunctions,
//  outputBuffer is whatever is in the output buffer. This works best  if ob_start() is used in the main php script
//  listOfCallerFunctions : the list of function calls (including line number in code) leading to this invocation of jsonRetunError
// This can be used with the js function wsurvey.getJson.check -- which display an "error report"

function jsonReturnError($acontent,$otherContent='') {
   $pout=ob_get_contents();
   ob_end_clean();
   $goo=debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS);
   $res=['status'=>'error',
         'content'=>$acontent,
        'backTrace'=>$goo,
        '_forceError'=>1,
       'otherContent'=>$otherContent,
       'print'=>$pout];

   header('Content-type: application/json');
   echo json_encode($res);
   exit;
}

?>