<?php
namespace wsurvey\adminLogon  ;
session_start();

//================
// a simple, slightly secure, logon function. Intended to support administrative logon (to otherwise open access scripts)
// works with wsurvey.adminLogon.js
// you MUST set wsurvey.adminLogon_params.php (in same directory as script that called wsurvey.CheckLlogon.php) --
//     wsurvey.adminLogon_params.php is where  password and other variables are set
//
// see  wsurvey.adminLogon_paramsOrig.php for an example
//
//===================

ob_clean();

$rootdir=$_SERVER['DOCUMENT_ROOT'] ;

$todo= extractARequestVar('todo','xxx');

// get logon parameters (logonname specific)
// useparams contains fields (for this attempt): logonName(from request), sessVar, passwordActual, pwdDuration
 $useParams=logonInit($todo)  ;

// and for conveniences below, set these for local use

  $wsurveyadminLogon_sessVar=$useParams['sessVar']   ;
  $logonName=$useParams['logonName'] ;
  $passwordActual=$useParams['passwordActual'] ;
  $pwdDuration=$useParams['pwdDuration'] ;

  if ($useParams['passwordActual']=='') {   // non empty password must be specified
    doJsonReturn(['status'=>'error','content'=>'No password specified for logonName: '.$useParams['logonName']]);  // error exit is not the same as "no success"
    exit;
  }

  if (!array_key_exists($wsurveyadminLogon_sessVar,$_SESSION)) $_SESSION[$wsurveyadminLogon_sessVar]=0;  // initialize?

// Setup is done ..... what to do?  -------------------



if ($todo=='logoff') {  // special case
 $nowtime=time();
 $wasStatus=$_SESSION[$wsurveyadminLogon_sessVar];
 $_SESSION[$wsurveyadminLogon_sessVar]=0;    // this signals "not logged on" (for this logonname)

 $amess="logoff. using logonNameStatusVariable= $wsurveyadminLogon_sessVar. Expiry was: $wasStatus (currentTime= $nowtime)  ";
 doJsonReturn(['status'=>'ok','content'=>$amess,'logonName'=>$logonName]);  // will exit
 exit;
}

if ($todo=='timeLeft') {  // special case

  $logonActive0= logonStatus($logonName);
  $astatus=$logonActive0[0];
  $timeLeft=$logonActive0[1];           // $timeLeft[0] is status (not used for this simple task) -- but timeLeft=0 [0]=0

  doJsonReturn(['timeLeft'=>$timeLeft,'status'=>$astatus]);
  exit;
}

if ($todo=='extendTime') {  // special case
  $nseconds=extractARequestVar('seconds',2000);
  $nseconds=intval($nseconds);
  if ($nseconds<1)  doJsonReturn(['timeLeft'=>0,'status'=>'error','content'=>'Bad extendtime value '.$nseconds]);
  $logonActive0= logonStatus($logonName);  // [0:not,1:yes,2:expiry, timeleft]
  $astatus=$logonActive0[0];
  $timeLeft=$logonActive0[1];           // $timeLeft[0] is status (not used for this simple task) -- but timeLeft=0 [0]=0
  if ($astatus==0) doJsonReturn(['timeLeft'=>0,'status'=>'no']);
  if ($astatus==2) {
     $_SESSION[$wsurveyadminLogon_sessVar]=time()+$nseconds ;   // new expiry time
  } else {
      $_SESSION[$wsurveyadminLogon_sessVar]+=$nseconds ;   // new expiry time
  }
  doJsonReturn(['timeLeft'=>$timeLeft+$nseconds,'status'=>$astatus,'joe'=>1 ]);     // note: js side will update $(document).datat(wsurveyadminLogon_status_'+logonName)
  exit;
}

// ....
// otherwise, call from wsurvey.adminLogon_askServer.
// perhas a first call, perhaps a first attempt, perhaps a later attempt

// check if already logged on, or if current pwd is correct. If so, returns 1 (logon on) or 11 (prior logon active)

  $astatX=logonTry(0,$useParams)  ;

  $infos=['status'=>'ok','mode'=>$astatX[0],'timeLeft'=>$astatX[1]]; // wsurveyadminLogon_sessVar set in logonTry

  doJsonReturn($infos);

  exit;


//=====================
// determine logon parameters (logonName specific. Return in an array

function logonInit($zaction) {


  $wsurveyadminLogon_params=[];  // maybe added to in  wsurvey.adminLogon_params.php 
  $useParams=['passwordActual'=>'.','pwdDuration'=>''];

  $logonName=extractARequestVar('logonName','');  // either 'name' or logonName'
  if ($logonName=='') $logonName=extractARequestVar('name','default');
  $tlogonName=trim($logonName);
  if ($tlogonName=='' || $tlogonName=='0') $logonName='default';      // '' becomes default (as does 0 or '0')
 $useParams['logonName']=$logonName ;   // add this

 $wsurveyadminLogon_sessVar='wsurveyadminLogon_status_'.$logonName ;
 $useParams['sessVar']=$wsurveyadminLogon_sessVar;

   if ($zaction=='logoff' || $zaction=='timeLeft' || $zaction=='extendTime') return $useParams ;


// the following defaults are usually updatedtten by values specified in  wsurvey.adminLogon_params.php
  $passwordActual="";       // the administrative password -- this will be hashed by the client before being sent to the server -- it MUST be specified
  $pwdDuration=2000;                     // in  seconds (pwd expires after this amount of time)

  $paramsDir=extractARequestVar('paramsDir','');
   if ($paramsDir=='') {
      $curDirUse=getcwd();
   } else {
      $rootdir=$_SERVER['DOCUMENT_ROOT'] ;
      $curDirUse=$rootdir.$paramsDir;
      if (!is_dir($curDirUse)) {
         doJsonReturnError("wsurvey.adminLogon error: no such directory ($curDirUse) for wsurvey.adminLogon_params.php ");
         exit;
      }
   }
   $getParamsFile=$curDirUse.'/wsurvey.adminLogon_params.php';
   if (!is_file($getParamsFile)) {
         doJsonReturnError("wsurvey.adminLogon error:  directory ($curDirUse) does not contain wsurvey.adminLogon_params.php");
         exit;
      }

  require_once($getParamsFile);  // default, or logonName specific, values for the above 3 vars

  $noLogonNameParams=0;
  if (count($wsurveyadminLogon_params)==0) $noLogonNameParams=1;  // if no logonName specific params in params.php, than use defaults all the time

  if (!array_key_exists('default',$wsurveyadminLogon_params)) {   // save (possibly updated) defaults, if not explicitly specified
      $wsurveyadminLogon_params['default']=['passwordActual'=>$passwordActual,'pwdDuration'=>$pwdDuration];
  }


// if no such logonName --  use defaults, or stop with error.
 if ($noLogonNameParams==1 || (!array_key_exists($logonName,$wsurveyadminLogon_params)) ) {      // no match ..
    if ($noLogonNameParams==1) {          // no  logon name specifics, so all logon names use the default
       $useParams=$wsurveyadminLogon_params['default'] ;
    } else {                         // // if any logonName specific parametesr, than the requested logonName must be specified
       doJsonReturn(['status'=>'error','content'=>'No such logonName: '.$logonName,'logonName'=>$logonName ]);  // error exit is not the same as "no success"
       exit;
    }
 } else {   // match -- use it
     $useParams=$wsurveyadminLogon_params[$logonName] ;  // logonName specific parameters -- perhaps the default
 }

 $useParams['logonName']=$logonName ;   // add this

 $wsurveyadminLogon_sessVar='wsurveyadminLogon_status_'.$logonName ;
 $useParams['sessVar']=$wsurveyadminLogon_sessVar;

// use defaults, perhaps set in wsurvey.adminLogon_params.php not defined
 if (!array_key_exists('passwordActual',$useParams)) $useParams['passwordActual']='';
 if (!array_key_exists('pwdDuration',$useParams)  ) $useParams['pwdDuration']=$pwdDuration;


  return $useParams ;
}

//-----------------------------

// this does most of the work
// returns:
 //  ['prior',expiryTime] -- still logged on
 //  ['yes',expiryTime] -- password worked, newly logged on
 //  ['no',0]  -- unable to logon using password
 //  ['expired',0]   -- was logged on, but now expired -- and no password to try to use
 //  ['new',0  ]   -- never logon -- and no password to try to use

// useparams contains fields (for this attempt): logonName, sessVar, passwordActual, pwdDuration

function logonTry($forceLogon,$useParams) {

   $wsurveyadminLogon_sessVar=$useParams['sessVar'];   $pwdDuration=$useParams['pwdDuration'];
   $passwordActual=$useParams['passwordActual']; $logonName=$useParams['logonName'] ;

   $logonActive0=logonStatus($logonName)  ;  // [0] = 1: active, 0: never, 2:expired , [1] 0 or expiryTIme
   $logonActive=$logonActive0[0];$timeLeft=$logonActive0[1];

   if ($logonActive===1 && $forceLogon!=1){              // active logon --
      return ['prior',$timeLeft ] ;   // no need to logn
   }

//  not logged on, or a forced  logon
   $_SESSION[$wsurveyadminLogon_sessVar]=0 ;     // clear the flag

  $myPass=extractARequestVar('password','');   // if no password, this is the 'setup' call attempt
 
  if ($myPass=='') {  // '' means if not prior, don't try to logon. Just return mode (new or prior)
     if ($logonActive==0) return ['new',0] ;  // not logged on previously
     return ['expired',0];                 // logged on previolusly
  }

// password provided -- get salt provided by client, and use it to check password
  $asalt=extractARequestVar('salt','');
  $saltedPwd=$asalt.'_'.trim($passwordActual);

  if (substr($asalt,0,4)=='MD5_') {   // this signals that md5 was used to hash
     $useMd5=1;
     $hashedPasswordActual=md5($saltedPwd);
  } else {
     $useMd5=0;
     $hashedPasswordActual=crc32($saltedPwd);
  }

  if ($hashedPasswordActual!=$myPass) {          // no match:
      return ['no',0];
  }

// if here, success!

  $_SESSION[$wsurveyadminLogon_sessVar]=time()+$pwdDuration ;   // expiry time

  return ['yes',$pwdDuration];
}



//===============
// simple utility to return logon status (using json)
function doJsonReturn($Lstatus) {
     ob_end_clean();
     if (!array_key_exists('status',$Lstatus)) $Lstatus['status']='error';
     if (!array_key_exists('content',$Lstatus)) $Lstatus['content']='';
     $pout=trim(ob_get_contents());
     $Lstatus['print']=$pout;

     header('Content-type: application/json');
     echo json_encode($Lstatus);
     exit;
 }
function doJsonReturnError($amess) {
     ob_end_clean();
     header('Content-type: application/json');
     $Lstatus=['status'=>'error','content'=>$amess];
     $pout=trim(ob_get_contents());
     $Lstatus['print']=$pout;
     echo json_encode($Lstatus);
     exit;
 }

//-------------------
// currently logged on?
// returns [status,timeLeft]
// Status:
//    0 : not logged
//    1 : logged on
//   2 : was logged on, but expired
// timeLeft is in seconds -- until expiry. 0 means "expired or not logged on"

function logonStatus($useL ) {
  $sessVar='wsurveyadminLogon_status_'.$useL ;

  if (isset($_SESSION[$sessVar]) && $_SESSION[$sessVar]!=0 ) {  // got recent logon
     $logonExpiry=intVal($_SESSION[$sessVar]);
     if (!is_numeric($logonExpiry)) return [0,0 ] ;  // bad logon, so not logged on
     $nowTime=time();
     $timeLeft= $logonExpiry-$nowTime ;
     if ($timeLeft<=0  ) return [2,0 ];       // expired

     return  [1,$timeLeft ];
  } else {
     return [0,0 ];
  }
}



//============
// get a request var
function extractARequestVar($varname,$default='0' ) {
$varname=trim(strtoupper($varname));
foreach ($_REQUEST as $vname=>$oof) {
     $avar=trim(strtoupper($vname)) ;
     if ($avar==$varname)    return $oof ;
}
return $default ;
}
?>

