
// an ajax requester, and response functions, for retrieving json'ized arrays returned by server
// The two main functions are wsurvey.getJson.get, and wsurvey.getJson.check
//    wsurvey.getJson.get Make a request to a server, response is in a json'ized object, that is sent to a specified callback
//    wsurvey.getJson.check. Call back calls this to validate and parse stuff returned from server
// Other functions:
//    wsurvey.getJson.setErrFunc:  set the function to use in case of errors. If not specified, alert() is used. Can be called once (at start of program)
//    wsurvey.getJson.checkError : does the validation. For internal use (by wsurvey.getJson.check)
//
// This works with wsurvey.getJson.php!

if (typeof(wsurvey)=='undefined')  {
    var wsurvey={};
}
wsurvey.getJson={} ;  // define a "namespace" for functions

wsurvey.getJson.prePend='';      // prepend to url, if url does NOT start with  ' '  -- this can be set after wsurvey.getJson.js is loaded
wsurvey.getJson.errFunc='alert';   // how to display errors. SHould be initialzed to something more useful by calling program
                                     // wsurvey.getJson.setErrFunc(afunction) can be used
//===================================
//=================
// a front end to jQuery.ajax, optimized for json response. With error detection
//    aurl : server side program (.php) to call   -- might have getJson.prepend prepended
//    adata: data to send to server side program. Can be read by server side program (ie.;as a $_REQUEST var.)
//            May include stuff meant for transfer to the callback (not for server use)
//     acallback: function to call after server sends response
//    errMess : optional error message to display (along with error info)

wsurvey.getJson.get=function(aurl,adata,acallback,errMess) {
   var acallbackArg={};

   if (arguments.length<4) errMess="Call from "+arguments.callee.caller.name;
   
    if (jQuery.isArray(acallback)) {   // extra args NOT sent to server
         acallbackArg=acallback[1];
         acallbackArgGot=1;
         acallback=acallback[0];
    }

   if (typeof(acallback)!=='function') {
      if (typeof(acallback=='string')) {
         if (typeof(window[acallback])=='function') {
             acallback=window[acallback];
         } else {
             alert('wsurvey.getJson.get ('+errMess+') bad callback (not a function): '+acallback);
             console.trace('bad callback (not a function): '+acallback);
             return 0;
         }          // could not convert string to function pointer
      } else {        // acallback not a string
          console.trace('bad callback (not a function, not a name of a function): '+typeof(acallback)  );
          alert('wsurvey.getJson.get ('+errMess+'): bad callback (not a function, not a name of a function): '+typeof(acallback));
          return 0;
      }      // callback a  string
    }   // callback

    let amethod='POST',aurlUse=aurl;
    if (jQuery.isArray(aurl)) {
        amethod=aurl[1];
        aurlUse=aurl[0];
    }

    if (wsurvey.getJson.prePend!=='') {
        if (aurlUse.substr(0,1)!=' ') {
            aurlUse=wsurvey.getJson.prePend+aurl;
        }    else {
            aurlUse=jQuery.trim(aurl);
        }
    }

// go get it!
//
     jQuery.ajax({
       url: aurlUse,
       data:adata,
       method: amethod,
       dataType:'json',
       success: function(data,textStatus,jqXHR){
          acallback(data,adata,acallbackArg,textStatus,jqXHR);
       },
       error: function(jqXHR,textStatus ) {
          console.trace(errMess+' : ' +textStatus);

          let amess='<h5>'+errMess+'</h5>';
          amess+='<br>Error: ('+textStatus+') from '+aurl;
          amess+='<pre>'+jqXHR['responseText']+'</pre>';
          window[wsurvey.getJson.errFunc](amess);
          return 1;
        }
     });

    return 1;
}

////==================== ==================================
// converts a jsonized string to an array. Alerts an error if conversion (from a string) fails
// This can be used by the callback to make sure data is json, and to check for errors
//
// After converting (if necessary) the return from server into a jquery object:  checks for errors --
// if errors are found, calls  wsurvey.getJson.errFunc and returns false
//    zzdata: stuff returned from server (by the callback from wsurvey.getJson.get)
//    printOkay: 1 if stuff "printed" by server (rather than returned in json) is okay. Otherwise (default) it is assumed to be an error
//   amessage: optional error message
//
// Callback is called with the standard .ajax().done() arguments: (response,status,xhr)  
//   response:   data sent back (typically, useing jsonReturn
//   status: text message 9
//   xhr: the jqXHR object (information provided by .ajax)   https://api.jquery.com/jQuery.ajax/#jqXHR
// The zzdata argument sent to wsurvey.getJson.check is typically the 'response' argument sent to the callback by .ajax()

 wsurvey.getJson.check=function(zzdata,printOkay,amessage) {
  var  zdata;

  if (arguments.length<2) printOkay=0;  // non-emtpy print is an ERROR
  if (arguments.length<3) amessage="Call from "+arguments.callee.caller.name;

// convert from string? error if not proper json string format
  if (typeof(zzdata)=='string') {     // 'text' in .get field? Try to convert
    try {
       zdata=JSON.parse(zzdata) ;
    } catch(ee) {
       console.trace(amessage+':'+ ee.name+' | error='+ee.message);
       let aerr='<h4>json conversion error (<tt>'+ee.name+'</tt></h4> &hellip; in call from <b>'+amessage+'</b>:<br>' +ee.message;
       let az=wsurvey.dumpObj(zzdata,'var','Return from server ');
       window[wsurvey.getJson.errFunc](aerr+ '<hr><pre>'+az+'</pre>');
       return false;
    }
  } else {      // 'json' in get field, so already converted
     zdata=zzdata;
  }

// print not empty and not print okay, force error
  let printStuff= (typeof(zdata['print'])=='undefined') ? '' : jQuery.trim(zdata['print']);
  if (printStuff!='' && printOkay!=1) zdata['_forceError']=1;  // force an error, even if status=ok

// now check for error
  let arf= wsurvey.getJson.checkError(zdata,amessage);
  if (arf!==0) return false;
  return zdata ;

}

//================
//front end to  wsurvey.getJson.check. If no error, return 'content' field

wsurvey.getJson.content=function(aresponse,printOkay,amessage) {
  if (arguments.length<2) printOkay=0;  // non-emtpy print is an ERROR
  if (arguments.length<3) amessage="Call from "+arguments.callee.caller.name;

  let xx=wsurvey.getJson.check(aresponse,printOkay,amessage) ;
  if (xx===false) return xx;
  if (typeof(xx['content'])=='undefined') return false;
  return xx['content'];
}


//====================
// display error returns from serverside   -- 0 means "no error", n>0 (ie.; "1") means error was found!
// this is called by wsurvey.getJson.check. It could be called indepenently


wsurvey.getJson.checkError=function(hh,amessage) {
  if (arguments.length<2) amessage=arguments.callee.caller.name ;

  var doit=1;   // # non-empty fields shown (always show header)

  if (typeof(hh)!=='object') {
      console.trace('wsurvey.getJson.check: first argument is not an ojbect ');
      return 1 ;  // give up -- should never happen -- so must be an error
  }

  if (typeof(hh['_forceError']=='undefined')) {  // not a forced error     (i.e.; a  non emtpy print, but print is not allowed
      if (typeof(hh['status'])=='undefined') return 0 ; // not a forced error, not a php signal of an error ... assume okay
      if (hh['status']!='error') return 0 ;             // 0 means "no error"  -- THIS IS THE MAIN CHECK FOR "no error
  }

// if here, status=error, or forcedError (ie print non empty)

  origStatus= (typeof(hh['status'])=='undefined') ? 'problem ' : hh['status'] ;

//if _forceError exists, this is an error (regardleess of 'error' field

   var zzMain='',zzOther='',zzErrors='',zzBack='',zzPrint='';
   if (typeof(hh['content'])=='object') {
     zzMain='Contents= <pre>'+wsurvey.dumpObj(hh['content'],'var')+'</pre>';
     doit++;
   }   else {
      zzMain=hh['content'];
     doit++;
   }
   if (typeof(hh['otherContent']!='undefined') &&  hh['otherContent']!='') {
         zzOther='otherContent = <pre>'+wsurvey.dumpObj(hh['otherContent'],'var','')+'</pre>';
        doit++;
   }

   if (typeof(hh['errors']!='undefined')) {
        if (jQuery.trim(hh['errors'])!='') {
           zzErrors='session[errors] = <pre>'+wsurvey.dumpObj(hh['errors'],'var')+'</pre>';
           doit++;
        }
   }
   if (typeof(hh['backTrace']!='undefined')) {
         zzBack='backTrace = <pre>'+wsurvey.dumpObj(hh['backTrace'],'var')+'</pre>';
        doit++;
   }
   if (typeof(hh['print']!='undefined')) {
        if (jQuery.trim(hh['print'])!='') {
           zzPrint='outputBuffer = <pre>'+wsurvey.dumpObj(hh['print'],'var')+'</pre>';
           doit++;
        }
   }
   let stuff='<h4>'+amessage+' (<tt>'+origStatus+'</tt>)</h4>'+zzMain;
        stuff+='<hr width="60%">'+zzOther;
        stuff+='<div style="width:95%;border-top:2px solid blue;margin-top:0.5em">Output buffer</div>' +zzPrint;
        stuff+='<div style="width:95%;border-top:2px solid blue;margin-top:0.5em">Other errors</div>' +zzErrors;
        stuff+='<div style="width:95%;border-top:2px solid blue;margin-top:0.5em">php backtrace</div>' +zzBack;

   console.trace('wsurvey.getJson.check got an error response ');
     window[wsurvey.getJson.errFunc](stuff);


   return doit;
}

//=======================
// set the getJson error reporting function
// afucntion is called with one argument -- the error messages (which might be long, with multiple divs)

wsurvey.getJson.setErrFunc=function(afunction) {

  if (typeof(afunction)=='string') {
    if (typeof(window[afunction])!=='function') {
       console.trace('wsurvey.getJson.setErrFunc error: error reporting function ('+afunction+') is not a function ')
       alert('wsurvey.getJson.setErrFunc error: error reporting function ('+afunction+') is not a function ');
       return false;
    }
 //   afunction=window[afunction];
  } else {
     alert('errFunc must be a string.');

  }

  wsurvey.getJson.errFunc=afunction ;
  return 1;
}

// === dumpObj (if wsurvey.utils1 not available
if (typeof (wsurvey.dumpObj)!=='function') {
  wsurvey.dumpObj=function(e,r,n){r=void 0===r||""==jQuery.trim(r)?"alert":r,1==(r=jQuery.trim(r).toLowerCase())&&(r="alert");arguments.length<3?n="":n+=" \n";var t=wsurvey.dump0(e,0);return t=n+t,"alert"==r?alert(t):"console"==r&&console.log(t),t},wsurvey.dump0=function(e,r){var n,t=typeof e,o=t;switch(t){case"number":case"boolean":o+=": "+e;break;case"string":o+="("+e.length+'): "'+e+'"';break;case"object":if(null===e)o="null";else if("[object Array]"===Object.prototype.toString.call(e)){o="array("+e.length+"): {\n";for(var a=0;a<e.length;a++)o+=l("   ",r)+"   ["+a+"]:  ",o+=wsurvey.dump0(e[a],"none",r+1)+"\n";o+=l("   ",r)+"}"}else{for(var u in n="{\n",cnt=0,e)n+=l("   ",r)+"   "+u+":  "+wsurvey.dump0(e[u],"none",r+1)+"\n",cnt++;n+=l("   ",r)+"}",o+="("+cnt+"): "+n}}return o;function l(e,r){for(var n="",t=0;t<r;t++)n+=e;return n}};
}


