// =====================
// logon functions. requires jQuery.
// works with wsurvey.adminLogon.php
// see  wsurvey.adminLogon.txt, for usage instructions
// ======================

// =================
// front end to wsurvey.adminLogon.php   --
//
// two forms:
//      4 params: apwd, callbackLogon,logonName,whenCall
//     1 param: this  (or evt)  -- event pointing to clicked element.
//
//  apwd: password (raw) to use (hashed value is sent)
//  callbackLogon : string name of function to use as call back. Should NOT be a function that is an element in an object
//  logonName:  if '' or 0, 'default' is used.
//  whenCall : 0/1/2 : when to call the calbackLogon
//
// If 1 param: apwd is from the .val() of the event.
//      callbackLogon, logonName, and whencall are from aattrigbutres, or .data (if .on() was used)
// the .php is called on 3 palces: logoncall, logoffcall, and timeleft call
// If 'wsurveyadmin_php' global js variable does NOT exist, a path of
//  '/wsurvey/wsurvey.lib/php/wsurvey.adminLogon.php' is used.
// If 'wsurveyadmin_php' exists, it should be a path to wsurvey.adminLogon.php -- either
//  fully qualified, or relative to script that contains this javascript function

if (typeof(wsurvey)=='undefined')  {
    var wsurvey={};
}



wsurvey.adminLogon=function(athis0,callbackLogon,logonName,whenCall)  {
  var aevt='',apwd,ethis='';
  var apwd ;

  if (arguments.length==0) {
     apwd=''; callbackLogon=''; logonName='default'; whenCall=0 ;  // simple defaults
  }
  if (arguments.length==4) {
      apwd=athis0;
      logonName=jQuery.trim(logonName);
      if (logonName=='' || logonName==0) logonName='default';
  }

  if (arguments.length<4  && arguments.length>0) {


    ethis=wsurvey.adminLogon_evt(athis0);
     if (ethis.length==0) {
           alert('wsurvey.adminLogon error: first argument is not a  jQuery object ');
           return 1
    }
    apwd=wsAttr(ethis,athis0,'pwd',false);

    callbackLogon=jQuery.trim(wsAttr(ethis,athis0,'callbackLogon',''))  ;
    if (callbackLogon=='0') callbackLogon='' ;
    if (callbackLogon!='') {
       if (typeof(window[callbackLogon])!='function') {
           alert('wsurvey.adminLogon error: '+callbackLogon+' is not a function (it can not be a method of an object)');
          return 1 ;
       }
    }

    logonName=jQuery.trim(wsAttr(ethis,athis0,'logonName','default'));
    if (logonName=='' || logonName==0) logonName='default';

    whenCall=parseInt(wsAttr(ethis,athis0,'whenCall',0));
    if (whenCall!=1 && whenCall!=2 ) whenCall=0;

    if (apwd===false) {         // look in the text field for the password entry
        let eparent=ethis.closest('[name="wsurveyadminLogon_passwParent"]');
        if (eparent.length==0)  {
              alert('wsurvey.adminLogon error: unable to find wsurveyadminLogon_passwParent ');
             return 0;
        }
       let epwd=eparent.find('[name="wsurveyadminLogon_passw"]');
       if (epwd.length==0)  {
              alert('wsurvey.adminLogon error: unable to find wsurveyadminLogon_passw ');
             return 0;
       }
       apwd=epwd.val();   // do NOT look for pwd attribute in the input field. ONly in the submit button
    } // apwd=false
  }   // args  <4 > 1

  wsurvey.adminLogon_askServer(apwd,logonName,callbackLogon,whenCall,ethis);  // this does the work

   return 1;

  function wsAttr(ethis,athis,what,adef) {
    var a1,a2  ;
    if (typeof(athis.data)!=='undefined') {  // .on(,data,) call? Hishtest precedence
       if (typeof(athis.data[what])!=='undefined') return  athis.data[what]  ;
    }
    a1=ethis.attr('data-'+what);
    if (typeof(a1)=='undefined' || a1===null) {
       a2=ethis.attr(what);
       if (typeof(a2)=='undefined' || a1===null) return adef;  // no match, return def
       return a2;            // return awhat
     } else {
       return a1;           return data-awhat
     }
  }   // wsattr

}  // adminLogon

//--
// called by wsurvey.adminLogon
//  submit request to server to validate password
// this generates a salt and hashed password, and sends them   to the server
wsurvey.adminLogon_askServer=function(bpwd,logonName,callbackLogon,whenCall,ethis) {
    var mypass='',  asalt=''   // assume request form call
    var gotMd5=0;
    if (typeof(window['md5'])=='function') gotMd5=1;

    let asalt0=""+(" "+Math.random()).substr(3);
    let asalt1=""+(" "+Math.random()).substr(3);
    asalt=asalt0+asalt1 ;
    if (gotMd5==1) {
        asalt='MD5_'+asalt;   // signal to server that md5 should be used
    } else {
        asalt='CRC32_'+asalt;      // signal to server that crc32 should be used
    }

// md5 available: use it. Otherwise, crc32
    if (jQuery.trim(bpwd)!='') {
      let tocheck=asalt+'_'+jQuery.trim(bpwd) ;
      if (gotMd5==1) {
         mypass=md5(tocheck);  // the md5 hashed password
      } else {
         mypass=wsurvey.adminLogon_crc32(tocheck);  // the crc32 hashed password
      }
    } else {
         mypass='';   // signals "make password entry container"
    }

    var loc = window.location.pathname;
    var gadir = loc.substring(0, loc.lastIndexOf('/'));   // where to find wsurvey.adminLogon_params.php
    var adata={'todo':'adminLogon','paramsDir':gadir,'password':mypass,'salt':asalt,'logonName':logonName};

    let aurlUse ;
    if (typeof(window['wsurveyadmin_php'])===false) {
        aurlUse='/wsurvey/wsurvey.lib/php/wsurvey.adminLogon.php';
    } else {
        aurlUse=window['wsurveyadmin_php'];
    }

     jQuery.ajax({
       url: aurlUse,
       data:adata,
       method: 'post',
       dataType:'text',
       success: function(data,textStatus,jqXHR){
          wsurvey.adminLogon_fromServer(data,logonName,callbackLogon,whenCall,textStatus,jqXHR,ethis);
       },
       error: function(jqXHR,textStatus ) {
          let amess=' Error: ('+textStatus+') from '+aurlUse;
          console.trace(amess+' : ' +textStatus);
          alert(amess);

          return 1;
        }
     });


}

//===============
// wsurvey.adminLogon_fromServer is a callback from the server (after a call to server by wsurveyadminLogon_askServer
// It can displaya the logon form, or return a logged on message (either due to rcent logon, or correct password)
// hh['status'} :  0=bad password, 'ok'=success (new logon), 2=first logon (display form), 11=sucess (active logno)

wsurvey.adminLogon_fromServer=function(zdata,logonName,callbackLogon,whenCall,textStatus,jqXHR,ethis) {

     var hh ;
     hh=zdata;
      if (typeof(zdata)=='string') var hh= JSON.parse(zdata);
     var astat=hh['status'] ;
      if (astat=='error') {
         alert(hh['content']);
         return 1;
     }
     let pout=hh['print'];
     if (jQuery.trim(pout)!='') {
         alert('non-empty output: '+put);
         return 1;
     }

     var amode=hh['mode'];   // 'no', 'yes', 'prior', 'expired', or 'new'
     var timeLeft=hh['timeLeft'];

     if (whenCall==1)  {         // always call callbackLogon with results, and let it deal with the next step  -- success failure first, whatever
        if (callbackLogon=='')  {              // use default
           if (typeof(window['wsurveyadminlogon_quiet'])=='undefined' || window['wsurveyadminlogon_quiet']!='1') {
               console.log('mode='+amode+', logonName='+logonName+', timeLeft='+timeLeft);
           }
        } else {        // callbacklogon was checked above (for being an existing function)
           window[callbackLogon](amode,logonName,timeLeft);  // deal with success.
        }
        return 1;
     }

// remove prior auto-generated box
    if (typeof(ethis)!='string') {
            let eform=ethis.closest('[name="wsurveyadminLogon_passwParent"]');
            if (eform.length==1)  {
                eform.remove() ;
            }
    }


// not whencall=1  -- sucess
     if (amode=='yes' || amode=='prior') {       // prior logon still active, or correct password provided

       let nowtime=Date.now();
       let expiryTime=nowtime+(timeLeft*1000);  // convert php seconds to js milliseconds
       let expiryTime2=new Date(expiryTime);
       let expiryTimeStamp=expiryTime2.toLocaleString('en-US');
       let tlist=[timeLeft,expiryTime,expiryTimeStamp];
       let statusName='wsurveyadminLogon_status_'+logonName ;
       $(document).data(statusName,tlist);


       if (callbackLogon=='')  {              // use default
           if (typeof(window['wsurveyadminlogon_quiet'])=='undefined' || window['wsurveyadminlogon_quiet']!='1') {
              console.log('mode='+amode+', logonName='+logonName+', timeLeft='+timeLeft);
           }
       } else {                  // callback specified
         window[callbackLogon](amode,logonName,timeLeft);  // deal with success.
       }
       return 1 ;

     }    // ok

// if here, not already logged on, or not correct password.
    let statusName='wsurveyadminLogon_status_'+logonName     ;
    $(document).data(statusName,[]);

    let aa='';              // 'new' -- nothing to add
    if (amode=='no') {                    // 'no', 'yes', 'prior', 'expired', or 'new'
       aa="Incorrect password: please re-enter ";
    }
    if (amode=='expired') {
       aa='Prior logon expired. Please re-enter password';
    }
    let stuff=logonMakeForm(aa);
    $(document.body).append(stuff).show();
    let eform=$('#wsurveyadminLogon_form');
    let einput=eform.find('[name="wsurveyadminLogon_passw"]');
    einput.on('keyup',wsurvey.adminLogon_keyup);
    if (whenCall==2) {
       if (callbackLogon=='')  {              // use default
         if (typeof(window['wsurveyadminlogon_quiet'])=='undefined' || window['wsurveyadminlogon_quiet']!='1') {
             console.log('mode='+amode+', logonName='+logonName+', timeLeft='+timeLeft);
         }
       } else {                  // callback specified
         window[callbackLogon](amode,logonName,timeLeft);  // deal with success.
       }
    }
    window.setTimeout( function() { $('[name="wsurveyadminLogon_passw"]').focus();},100); // shift focus to the password input box on this form
    return 1;   // dont use logoncallback


//======  iontenral function
  function  logonMakeForm(aa) {
       var aadd;

      if (typeof(window['wsurveyadmin_logonClass'])=='undefined' || jQuery.trim(window['wsurveyadmin_logonClass'])=='') {
          aadd=' style="padding:9px 5px 5px 5px;position:fixed;left:40%;top:20%;width:30%;height:6em;border:1px solid black;border-radius:3px;background-color:#dfdfcf;" ';
      } else {
         aadd=' class="'+jQuery.trim(window['wsurveyadmin_logonClass'])+'" ';
      }
     let s3='';
     s3+='<div name="wsurveyadminLogon_passwParent"  '+aadd+' >';
     s3+='<input type="button" value="x" title="Close this logon box"  onClick="wsurvey.adminLogon_closeParent(this)"> ';
     s3+='<span style="padding:3px 1em 3px 1em;font-weight:700">'+aa+'</span> ';
     if (logonName!='default' && logonName!='') s3+="<em>For "+logonName+"  &hellip; </em>" ; // personalize (if not default)
     s3+='Enter the password: <input value=" " title="Enter password.&#010; and then hit the Enter key, or hit the submit button "  name="wsurveyadminLogon_passw" type="text" length="20" />';
     s3+='    <br />And then ';
     s3+='  <input type="button" value="Submit it"  title="Click here after entering your password" name="wsurveyadminLogon_submit" ';
     s3+='     callbackLogon="'+callbackLogon+'" logonName="'+logonName+'" whenCall="'+whenCall+'" onClick="wsurvey.adminLogon(this)">  ';
     s3+='</div>';
     return s3 ;     // the page to be returned (printed)
  }    //logonMakeForm

}   // adminLogon_fromServer


// ===================


// submit password via the enter key (skip the submit button)
wsurvey.adminLogon_keyup=function(evt) {
     if (evt.which==13)  {
         let eevt=wsurvey.adminLogon_evt(evt);
        if (eevt===false) return true ;   // cant fiind submit buttom
        let eparent=eevt.closest('[name="wsurveyadminLogon_passwParent"]');
        if (eparent===false) return true ;   // cant fiind submit buttom
        let esubmit=eparent.find('[name="wsurveyadminLogon_submit"]');
        if (esubmit===false) return true ;   // cant fiind submit buttom
        esubmit.focus().click();
        return false;      // preent default
     }
     return true;
}

// =============   ==========================
// useful functions
 

//==================
// logoff
wsurvey.adminLogon_logoff=function(logonName,callbackLogoff) {
  let statusName='wsurveyadminLogon_status_'+logonName ;
   $(document).data(statusName,[]);
     logonName=jQuery.trim(logonName);
   if (logonName=='' || logonName==0) logonName='default';

  if (arguments.length<2) callbackLogoff='';

    var loc = window.location.pathname;
    var gadir = loc.substring(0, loc.lastIndexOf('/'));
    var adata={'todo':'logoff','paramsDir':gadir,'logonName':logonName};

    let aurlUse ;
    if (typeof(window['wsurveyadmin_php'])===false) {
        aurlUse='/wsurvey/wsurvey.lib/php/wsurvey.adminLogon.php';
    } else {
        aurlUse=window['wsurveyadmin_php'];
    }

     jQuery.ajax({
       url: aurlUse,
       data:adata,
       method: 'post',
       dataType:'text',
       success: function(data,textStatus,jqXHR){
          wsurvey.adminLogon_logoff2(data,logonName,callbackLogoff,textStatus,jqXHR );
       },
       error: function(jqXHR,textStatus ) {
          let amess=' Error: ('+textStatus+') from '+aurlUse;
          console.trace(amess+' : ' +textStatus);
          alert(amess);

          return 1;
        }
     });


  return 1;
}

wsurvey.adminLogon_logoff2=function(zdata,logonName,callbackLogoff,tstatus,xhr) {

     var hh ;
     hh=zdata;
     if (typeof(zdata)=='string') var hh= JSON.parse(zdata);
     if (hh['status']!='ok') alert('Unable to fully logoff  (server side issues)' ) ;  // shouldn't happen

      let statusName='wsurveyadminLogon_status_'+logonName   ;
      $(document).data(statusName,[]);

     if (callbackLogoff=='') return 1;  // do nothing if no calback
     if (typeof(window[callbackLogoff])!='function') {
       alert("wsurvey.adminLogon_logoff error: bad callback function: "+callbackLogoff);
       return 1;
     }
     window[callbackLogoff](logonName,hh['content']);  // deal with success
     return 1;
}

// =======================
// check logon status. Returns
// If serverCheck=1, then get the current status from the server
//    Otherwise, use information stored on the client's browser -- which may not be fully accurate
// logonName is the logonName supplied to wsadminLogon in wsurvey.adminLogon_params.php --
//     if you forget what it is, it is returned as the logonName argument to the wsadminLogon callback function.
// Returns:
//    [0,'no'] : not logged on
//    [0,'exired'] : was logged on but now exired
//    [diff','yes']  : diff is  seconds remaining

wsurvey.adminLogon_status=function(logonName,acallback) {
   if (arguments.length<2) acallback=0;
     logonName=jQuery.trim(logonName);
   if (logonName=='' || logonName==0) logonName='default';

   if (acallback==0)  { // local lookup
     let statusName='wsurveyadminLogon_status_'+logonName   ;

     if (typeof($(document).data(statusName))!='object') return [0,'unknown'] ;
     let astatus=$(document).data(statusName)       ;
     if (astatus.length==0)      return [0,'no'] ;

     let nowt=Date.now();
     let diff=astatus[1]-nowt;    // expiry time - current time (all in local  milliseconds)

     if (diff<0) return [0,'expired'];
     return [diff/1000,'yes'];             // diff is in milliseceonds (.js time)

   }
// else, get current status from server

   var loc = window.location.pathname;
   var gadir = loc.substring(0, loc.lastIndexOf('/'));  // galleryDir':adir,
   var adata={'todo':'timeLeft','paramsDir':gadir,'logonName':logonName  };

    let aurlUse ;
    if (typeof(window['wsurveyadmin_php'])===false) {
        aurlUse='/wsurvey/wsurvey.lib/php/wsurvey.adminLogon.php';
    } else {
        aurlUse=window['wsurveyadmin_php'];
    }

     jQuery.ajax({
       url: aurlUse,
       data:adata,
       method: 'post',
       dataType:'text',
       success: function(data,textStatus,jqXHR){
          wsurvey.adminLogon_status2(data,logonName,acallback, textStatus,jqXHR );
       },
       error: function(jqXHR,textStatus ) {
          let amess=' Error: ('+textStatus+') from '+aurlUse;
          console.trace(amess+' : ' +textStatus);
          alert(amess);

          return 1;
        }
     });



}
wsurvey.adminLogon_status2=function(zdata,logonName,acallback, textStatus,jqXHR ) {
 
    var hh,tlist  ;
    hh=zdata;
    if (typeof(zdata)=='string') var hh= JSON.parse(zdata);

    var timeLeft=hh['timeLeft'];

    if (typeof(window[acallback])!=='function') {
        alert('wsurvey.adminLogon_status error. bad callback function: '+acallback);
        return 1;
    }

    var sstatus=parseInt(hh['status']);
    var sayStatusL=['no','yes','expired'];
    var sayStatus='unknown';
    if (typeof(sayStatusL[sstatus])!='undefined') sayStatus=sayStatusL[sstatus];

    if (timeLeft==0)   {
         tlist=[timeLeft,sayStatus] ;
         window.setTimeout(function() {window[acallback](tlist );},100);
         return 1;
    }

// sstatus:  0 : not logged,  1 : logged on,  2 : was logged on, but expired
     let tt=(timeLeft);
     tlist=[tt,sayStatus] ;
     window.setTimeout(function() {window[acallback](tlist)},100);

      return 1 ;
}

// ================= Some utilities =========

// simple utiity to close logon box
wsurvey.adminLogon_closeParent=function(athis) {
   var ethis=$(athis);
   var aclose=ethis.closest('div');
   $(aclose).hide();
   return 1;
}

//============
// convert (this) or (evt) to a jquery object (pointing to the dom element triggering this event)
wsurvey.adminLogon_evt=function(zevt) {
   if (zevt instanceof jQuery)  return zevt ;  // already jquery object
   var which='target',oof=0;
   if (typeof(zevt)=='string') {       // kind of odd to use this function for this, but just in case
       oof=$(zevt);
       if (oof.length==0) return false ;
       return oof ;
   }
   if (typeof(zevt)!=='object') return false ;   // should rarely happen
   if (typeof(zevt.originalEvent)!=='undefined' && typeof(zevt.target)!=='undefined') return $(zevt[which]);  // from an .on
   if (typeof(zevt.currentTarget)!=='undefined' && typeof(zevt.target)!=='undefined') return $(zevt[which]);  // from an .addEventListener
   oof=$(zevt);                  // a this
   if (oof.length==0) return false;
   return oof;
}

// crc32 checksum https://stackoverflow.com/questions/18638900/javascript-crc32
wsurvey.adminLogon_crc32=function(str,ashex) {
   if (arguments.length<2) ashex=0;
   var a_table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
   var b_table = a_table.split(' ').map(function(s){ return parseInt(s,16) });
    var crc = -1;
    for(var i=0, iTop=str.length; i<iTop; i++) {
        crc = ( crc >>> 8 ) ^ b_table[( crc ^ str.charCodeAt( i ) ) & 0xFF];
    }
    var  icrc=(crc ^ (-1)) >>> 0;
   if (ashex==0)  return icrc;

   if (icrc < 0) {
     icrc = 0xFFFFFFFF + icrc + 1;
   }
   acrc=parseInt(icrc, 10).toString(16);
   if (acrc.length==7) acrc='0'+acrc;
   return acrc;
}


//==============
// extend logon  by this many seconds (if logged on recently, could be expired!
wsurvey.adminLogon_extend=function(nseconds,logonName,amess) {
    if (arguments.length<2) logonName='default';
    if (arguments.length<3) amess='';
    logonName=jQuery.trim(logonName);
    if (logonName=='' || logonName=='0') logonName='default';

    if (isNaN(nseconds)) return false ; // fail silently
    nseconds=parseInt(nseconds);

    var adata={'todo':'extendTime','logonName':logonName,'seconds':nseconds};

     let aurlUse='/wsurvey/wsurvey.lib/php/wsurvey.adminLogon.php';
     jQuery.ajax({
       url: aurlUse,
       data:adata,
       method: 'post',
       dataType:'text',
       success: function(data,textStatus,jqXHR){
          wsurvey.adminLogon_extend2(data,logonName,amess,textStatus,jqXHR );
       },
       error: function(jqXHR,textStatus ) {
          let amess=' Error: ('+textStatus+') from '+aurlUse;
          console.trace(amess+' : ' +textStatus);
          alert(amess);

          return 1;
        }
     });

}
wsurvey.adminLogon_extend2=function(zdata,logonName,amess,zstatus,zxhr) {
   var hh  ;
    hh=zdata;

    if (typeof(zdata)=='string') var hh= JSON.parse(zdata);

    if (hh['status']=='error') {
       alert('Problem extending logon: '+hh['content']);
       return 0;
    }

    var timeLeft=hh['timeLeft'];
    let nowtime=Date.now();
    let expiryTime=nowtime+(timeLeft*1000);
    let expiryTime2=new Date(expiryTime);
    let expiryTimeStamp=expiryTime2.toLocaleString('en-US');
    let tlist=[timeLeft,expiryTime,expiryTimeStamp];
    let statusName='wsurveyadminLogon_status_'+logonName ;

    $(document).data(statusName,tlist);
    amess=jQuery.trim(amess);
    if (amess!='') amess=' || '+amess;
    if (typeof(window['wsurveyadminlogon_quiet'])=='undefined' || window['wsurveyadminlogon_quiet']!='1') {
       if (timeLeft>0) {
            console.log('Extend logon for '+logonName+' to '+expiryTimeStamp+ ' ('+expiryTime+'): timeLeft (seconds) = '+timeLeft +amess);
       } else {
          console.log('Unable to extend logon for '+logonName+ amess );
       }
    }
    return 1;
}



