<?php
namespace wSurvey\utilsP2 ;

/* wsurvey.utilsP2 : some more obscure useful php functions */


//===================================
//http://php.net/manual/en/function.nl2br.php
// replace <br> with crlf

function br2nl ( $string, $separator = PHP_EOL ){
    $separator = in_array($separator, array("\n", "\r", "\r\n", "\n\r", chr(30), chr(155), PHP_EOL)) ? $separator : PHP_EOL;  // Checks if provided $separator is valid.
    return preg_replace('/\<br(\s*)?\/?\>/i', $separator, $string);
}


//====================
// return size, in characters, of an array.  For integers and floats, the size is the printed size (i.e.; if $a[]=array(); $a[0]=612 ;  array_size_bytes($a) returns a value of 3
// fully recursive: the array can contain other arrays -- all elements in all embedded arrays are considrered
// note: if $a is not an array, this is the same as strlen

function array_size_bytes($a){

  if (!is_array($a)) {
     $zz=strlen($a);
	 return $zz;
  } else {
	   $size = 0;
	   foreach ($a as $v) {
		$aa=array_size_bytes($v)  ;
        $size +=   $aa;
       }
       return $size;
  }
}





//==============
// simple string obsfucator and unobsfuctor. Works with similar named functions in wsurveyUtils1.js
// THis can be used to obsfucate strings sent to javascript (and back again).
// It really is NOT an encryption, but might stop idle snoops (i.e.; those looking at source code of html documents)

function obsfucate($astring) {
    $a1=base64_encode($astring);
    $a2=str_replace('=','$',$a1);
    $a3=str_rot13($a2);
    return $a3 ;
}
function unobsfucate($astring) {
    $a1=str_rot13($astring);
    $a2=str_replace('$','=',$a1);
    $a3=base64_decode($a2);
    return $a3 ;
}

//=========
// count decimal precison   https://stackoverflow.com/questions/2430084/php-get-number-of-decimal-digits (adaptted to deal with - values)
// returns [digits,decimals] : # of digits in string (not including - or  .), # of decimal digits
// asinfo=0 : returns full accuracy number_format
// 1   = return #digits and # decimals (in 2 element array)
// nmax : optional. Max # of decimal digits to use  (if asinfo=0)
function numberPrecision($value,$asinfo=0,$nmax=12) {

 // Count the number of decimal places
if ($value<0) $value=abs($value);
$current = $value - floor($value);
for ($decimals = 0; ceil($current); $decimals++) {
    $current = ($value * pow(10, $decimals + 1)) - floor($value * pow(10, $decimals + 1));
}
// Count the total number of digits (includes decimal places)
$current = floor($value);
for ($digits = $decimals; $current; $digits++) {
    $current = floor($current / 10);
}
if ($asinfo=='1') return [$digits,$decimals];

$newv=number_format($value,min($decimals,$nmax));
return $newv ;

}





//=====================
// binary search in a sorted matrix -- each row is a vector --
//  search on the jcol'th column (of each row. If jcol not specified, or <0) matrix is a simple array
// Limit search to Barray[Bleft] to Barrary[Bright] (all elements if these are not specified
// update of  binarySearchIndex
//  returns index that brackets a value (the closest value in array that is <= the target value)
// returns -1 if  (Bvalue<Barray[0], count($Barray)-1 if Bvalue>end(Barray)  ...
//       otherwise ii s.t. Barray[ii]<=Bvalue<Barray[ii+1]
// special casses:  bvalue=Barray[0] : return 0.  bvalue=Barray[last]  : return last index (=count(Barray)-1)
//  Barray : the matrix
//  Bvalue :  the value to find (the index of Barray st Barray[index]<=BValue<Barray[index+1]
//  $ith  : column of Barray to examine (defult =1)
//  $Bleft : start searching at Barray[$Bleft]. Default it 0 (first element)
//  $Bright  : stop searcing at Barray[$Bright]. Default,  is end (count($Barray)-1). If <0, this many from end

function binarySearchMatrix($Barray, $Bvalue,$jcol=-1,$Bleft=0,$Bright=-1 ) {

   if ($Bright<=0) $Bright=count($Barray)+$Bright;  // portion of array to search in
   $Bright=min($Bright,count($Barray)-1);
   if ($Bleft<0) return null ;
   if ($Bright<$Bleft) return null ; // an error

   if ($Bright<0) {return -1 ;  }  // empty array  - so  less than first value"
     $bleftVal= ($jcol<0) ? $Barray[$Bleft] :  $Barray[$Bleft][$jcol] ;
       if  ($bleftVal==$Bvalue) {return 0; }  //  equals first value
       if ($bleftVal>$Bvalue) {return -1; }  //  before first value
     $brightVal= ($jcol<0) ? $Barray[$Bright] :  $Barray[$Bright][$jcol] ;
       if ($brightVal<=$Bvalue) return $Bright  ;   // after, or egual, to last value

    if ($Bright==1) return 0;     // 2 element array, and ge first and lt last ..  must be in between (after first element at [0])

    while ($Bleft <= $Bright) {
      if ($Bleft+1>=$Bright) return $Bleft  ;  {       // indices are equal, or next to each other --so return bleft (lower end)
      }
      $Bmidpoint = (int) floor(($Bleft + $Bright) / 2);
      $vmid= ($jcol<0) ? $Barray[$Bmidpoint] : $Barray[$Bmidpoint][$jcol]  ;
      $jj=0;
      if ($vmid<$Bvalue) {
             $jj=-1;
      } else if  ($vmid>$Bvalue) {  ;
             $jj=1;
       }

      if ($jj==-1) {           // The midpoint value is less than the value.
        $Bleft = $Bmidpoint ;
      } elseif ($jj==1) {        // The midpoint value is greater than the value.
         $Bright = $Bmidpoint ;
      } else {                                      // exact match?
        return $Bmidpoint ;             // exact match at this element of barray (so this element is lower bound)
      }

     }
     return NULL;   // should never happen

}
//=====================
// binary search, with optional callback for custom comparison
// if $f is specified, it is called with 2 arguments:
//   $f(Barray[icheck],$Bvalue)      (check the value of the icheck index in Barray against the value of Bvalue)
// and must return: -1,0, or 1  --
//      -1 : Barray[icheck]<Bvalue, 0 if = , 1 if >
//  Note that it is up to the caller to be sure that the arguments types expected by $f are the same types provided as the arguments to binarySearch
// If $f is not specified < and > are used
// returns -1 if  (Bvalue<Barray[0], count($Barray)-1 if end(Barray)>Bvalue ... otherwise ii s.t. Barray[ii]<=Bvalue<Barray[ii+1]
function binarySearchIndex($Barray, $Bvalue,$f=null) {

    $Bleft = 0;
    $Bright = count($Barray) - 1;     // Set the right pointer to the length of the array -1.

    $gotFunc=0;
    if (!is_null($f) && is_callable($f))   $gotFunc=1;

    if ($Bright<0) {return -1 ;  }  // empty array  - so "less than first value"

    if ($gotFunc==1) {
        if ($f($Barray[0],$Bvalue)==0) return 0 ;   // = first value
        if ($f($Barray[0],$Bvalue)==1) return -1 ;   // before first value
        if ($f($Barray[$Bright],$Bvalue)<=0) return $Bright  ;   // after or equal to last value
    } else {

       if (($Barray[0])==$Bvalue) {return 0; }  //  before first value
       if (($Barray[0])>$Bvalue) {return -1; }  //  before first value
       if (($Barray[$Bright])<=$Bvalue) return $Bright  ;   // after, or egual, to last value
    }

    if ($Bright==1) return 0;     // 2 element array, and ge first and lt last ..  must be in between (after first element at [0])

    while ($Bleft <= $Bright) {
      if ($Bleft+1>=$Bright) {       // indices are equal, or next to each other
           return $Bleft  ; // in between bleft and bright, so return bleft (lower end)
      }
      $Bmidpoint = (int) floor(($Bleft + $Bright) / 2);
      if ($gotFunc!==1) {
          $vmid=$Barray[$Bmidpoint]  ;
          $jj=0;
          if ($vmid<$Bvalue) {
             $jj=-1;
          } else if  ($vmid>$Bvalue) {  ;
           $jj=1;
          }
      } else {          // usefunc
        $jj=$f($Barray[$Bmidpoint],$Bvalue);
      }
      if ($jj==-1) {           // The midpoint value is less than the value.
        $Bleft = $Bmidpoint ;
      } elseif ($jj==1) {        // The midpoint value is greater than the value.
         $Bright = $Bmidpoint ;
      } else {                                      // exact match?
        return $Bmidpoint ;
      }

     }
    return NULL;   // should never happen

}

//===========
// golden rule search adapted from https://en.wikipedia.org/wiki/Golden-section_search
//    Given a function f with a single local minimum in the interval [a,b]
//     grSearch returns a subset interval  that contains the minimum.
//     $f : function to minimize.  MUST be an anonymous function declared BEFORE this is called, that accepts one or two arguments
//          Or: a 2 element array: $f[0] = the anonymous function, $f[1] = other argument(s)
//     $a0 : low end of range   (x values)
//     $b0  : upper end of range
//     $xtol : stop if  the two "golden rule points"  are less that this distance apart. The subset interval will be a bit larger than this
//            If not specified, 1e-5 is used.
//            Special case: if $xtol<0, $xtol is the number of steps to take.
//
//  Returns:
//     [$x0,$x1,$y,$n,$stopHow]

function grSearch($f0,$a0,$b0,$xtol=1e-5) {
  $invphi = (sqrt(5) - 1) / 2   ; //   0.6180339
  $invphi2 = (3 - sqrt(5)) / 2  ; // 0.3819660
  $a=min($a0,$b0);   $b=max($a0,$b0);          // a is point minX (point 1)$b is point maxX (point 4)
  $h = $b - $a   ;
  if (is_array($f0)) {
      $f=$f0[0];
      $z=$f0[1];
      $do2=1;
  } else {
      $f=$f0;
      $do2=0;
  }
  if ($xtol<0) {          // special case: use set # of iterations
      $n=intVal(-$xtol);  $xtol=0;
  } else {
      $n = intVal(ceil(log($xtol / $h) / log($invphi))) ;   // 'Required' steps to achieve tolerance
  }
  if ($h <= $xtol) {     // odd case, bounds very close, so just analyze at lower bound and return
     if ($do2==0) {
         $y0=$f($a);
     } else {
       $y0=$f($a,$z)  ;
     }
     return [$a,$b,$y0,0,0] ;
  }

    $c = $a + $invphi2 * $h    ;    // point #2
    $d = $a + $invphi * $h    ;     // point #3

     if ($do2==0) {
        $yc = $f($c)     ;
        $yd = $f($d)     ;
     } else {
        $yc = $f($c,$z)     ;
        $yd = $f($d,$z)     ;
     }

    for ($k=0;$k<$n;$k++) {    // up to $n iterations
        if ($yc < $yd) {
            $b = $d  ;                      // max = old point3. minx does not change
            $d = $c ;                       // point 3 = old point 2
            $yd = $yc    ;
            $h = $invphi * $h   ;
            $c = $a + $invphi2 * $h    ;  //  point 2 is between minx and  new point3
            $yc = ($do2==0) ?   $f($c)  : $f($c,$z)  ;
        } else {
            $a = $c  ;    // minx = old point 2
            $c = $d  ;    // point2 = old point 3
            $yc = $yd   ;
            $h = $invphi * $h   ;
            $d = $a + $invphi * $h  ;   // point3 is between old point 2 and old (still used) max
            $yd = ($do2==0) ?   $f($d)  : $f($d,$z)  ;
        }

        if (($b-$a)<$xtol) {         // if using set $n, $xtol=0 so never satisfied
          if ($yc < $yd) {
              return [$a,$d,$yc,$k,1]  ;
          } else {
              return [$c,$b,$yd,$k,2] ;
          }
       }

    }
    if ($yc < $yd) {
        return [$a,$d,$yc,$n,3]  ;
    } else {
        return [$c,$b,$yd,$n,4] ;
    }

}

//==================
// merge two ordered matrices. Each row of the arrays is a vector  -- use the ith element to determine order
// each matrix MUST be sorted in ascending order (on the values in column ith). 
// If not, use array_merge follwoed by a sort.

function  merge_ordered($gvals,$gadds,$ith=0) {
  $igAdd=0;
  $igExist=0;
  $igNew=0;
  $ggNew=[];
 
// trivial cases
   if (count($gvals)>0 && count($gadds)==0) return $gvals;
   if (count($gadds)>0 && count($gvals)==0) return $gadds;

   if ($gvals[0][$ith]<$gadds[0][$ith]) {
      $ggNew[0]=$gvals[0];      // start with first value in gvals
      $igExist=1;
   } else {            // gvals has smallest value
      $igNew=-1;
      for ($ig=0;$ig<count($gadds);$ig++) {
          if ($gadds[$ig][$ith]>$gvals[0][$ith]) break; // never true on ig=0
          $igNew++;
          $ggNew[$igNew]=$gadds[$ig];
          $igAdd=$ig;
      }
   }
  while (1) {                 // keep going until end of origijnal (gval) or addins (gadds). Then break
    if ($igExist>=count($gvals)) break ;

    $gg1=$gvals[$igExist][$ith];
    $gg2=$gadds[$igAdd][$ith];
    if ($gg1<=$gg2) {    // less than next add in
        $igNew++;
        $ggNew[$igNew]=$gvals[$igExist];
        $igExist++;
        continue;
    }               // else , add the next available addin
    $igNew++;
    $ggNew[$igNew]=$gadds[$igAdd];
    $igAdd++;
    if ($igAdd>= count($gadds) ) break ;   // all done, but check if anythign left in gvals
  }
  if ($igExist<count($gvals) ) {   // only one of these is true
     for ($ifoo=$igExist;$ifoo<count($gvals);$ifoo++) {
         $ggNew[]=$gvals[$ifoo];
     }
  }
  if ($igAdd<count($gadds))  {
     for ($ifoo=$igAdd;$ifoo<count($gadds);$ifoo++) {
         $ggNew[]=$gadds[$ifoo];
     }
  }

  return $ggNew;
}


//=====================
// convert string number (that can contain commas) to float value
//  i.e.;   removeCommasFromNumber('1,156,124.512') ==> 1156124.512,  removeCommasFromNumber('1,9.512,66')==> 19.51266
// 2nd arg is optional. If '1', convert to integer. Otherwise float returned
// //https://stackoverflow.com/questions/9334879/php-remove-commas-from-numeric-strings/9334947
function removeCommasFromNumber($aval,$toInt=0) {
   if (is_numeric($aval)) {  // catch sci notation
      if ($toInt!=0) return floatval($aval);
      return intval($aval);
   }

  $oof = floatval(preg_replace('/[^\d.-]/', '', $aval));

  if ($toInt!=0) $oof=intval($oof);
  return $oof;
}




/**
 * Better GI than print_r or var_dump -- but, unlike var_dump, you can only dump one variable.
 * Added htmlentities on the var content before echo, so you see what is really there, and not the mark-up.
 *
 * Also, now the output is encased within a div block that sets the background color, font style, and left-justifies it
 * so it is not at the mercy of ambient styles.
 *
 * Inspired from:     PHP.net Contributions
 * Stolen from:       [highstrike at gmail dot com]
 * Modified by:       stlawson *AT* JoyfulEarthTech *DOT* com
 *
 * @param mixed $var  -- variable to dump
 * @param string $var_name  -- name of variable (optional) -- displayed in printout making it easier to sort out what variable is what in a complex output
 * @param string $indent -- used by internal recursive call (no known external value)
 * @param unknown_type $reference -- used by internal recursive call (no known external value)
 */

function do_dump(&$var, $var_name = NULL, $indent = NULL, $reference = NULL) {
    $do_dump_indent = "<span style='color:#666666;'>|</span> &nbsp;&nbsp; ";
    $reference = $reference.$var_name;
    $keyvar = 'the_do_dump_recursion_protection_scheme'; $keyname = 'referenced_object_name';

    // So this is always visible and always left justified and readable
    echo "<div style='text-align:left; background-color:white; font: 100% monospace; white-space:nowrap; width:99%; color:purple;overflow:auto>";

    if (is_array($var) && isset($var[$keyvar]))
    {
        $real_var = &$var[$keyvar];
        $real_name = &$var[$keyname];
        $type = ucfirst(gettype($real_var));
        echo "$indent$var_name <span style='color:#666666'>$type</span> = <span style='color:#e87800;'>&amp;$real_name</span><br>";
    }
    else
    {
        $var = array($keyvar => $var, $keyname => $reference);
        $avar = &$var[$keyvar];

        $type = ucfirst(gettype($avar));
        if($type == "String") $type_color = "<span style='color:green;'>";
        elseif($type == "Integer") $type_color = "<span style='color:red'>";
        elseif($type == "Double"){ $type_color = "<span style='color:#0099c5'>"; $type = "Float"; }
        elseif($type == "Boolean") $type_color = "<span style='color:#92008d'>";
        elseif($type == "NULL") $type_color = "<span style='color:black'>";

        if(is_array($avar))
        {
            $count = count($avar);
            echo "$indent" . ($var_name ? "$var_name => ":"") . "<span style='color:#666666'>$type ($count)</span><br>$indent(<br>";
            $keys = array_keys($avar);
            foreach($keys as $name)
            {
                $value = &$avar[$name];
                do_dump($value, "['$name']", $indent.$do_dump_indent, $reference);
            }
            echo "$indent)<br>";
        }
        elseif(is_object($avar))
        {
            echo "$indent$var_name <span style='color:#666666'>$type</span><br>$indent(<br>";
            foreach($avar as $name=>$value) do_dump($value, "$name", $indent.$do_dump_indent, $reference);
            echo "$indent)<br>";
        }
        elseif(is_int($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".htmlentities($avar)."</span><br>";
        elseif(is_string($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color\"".htmlentities($avar)."\"</span><br>";
        elseif(is_float($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".htmlentities($avar)."</span><br>";
        elseif(is_bool($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".($avar == 1 ? "TRUE":"FALSE")."</span><br>";
        elseif(is_null($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> {$type_color}NULL</span><br>";
        else echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> ".htmlentities($avar)."<br>";

        $var = $var[$keyvar];
    }

    echo "</div>";
}
// === same as do_dump, but return as string
function do_dump_string(&$var, $var_name = NULL, $indent = NULL, $reference = NULL) {
    $do_dump_indent = "<span style='color:#666666;'>|</span> &nbsp;&nbsp; ";
    $reference = $reference.$var_name;
    $keyvar = 'the_do_dump_recursion_protection_scheme'; $keyname = 'referenced_object_name';

    $amess='';
    // So this is always visible and always left justified and readable
    $amess.= "<div style='text-align:left; background-color:white; font: 100% monospace; white-space:nowrap; width:99%; color:purple;overflow:auto>";

    if (is_array($var) && isset($var[$keyvar]))
    {
        $real_var = &$var[$keyvar];
        $real_name = &$var[$keyname];
        $type = ucfirst(gettype($real_var));
            $amess.= "$indent$var_name <span style='color:#666666'>$type</span> = <span style='color:#e87800;'>&amp;$real_name</span><br>";
    }
    else
    {
        $var = array($keyvar => $var, $keyname => $reference);
        $avar = &$var[$keyvar];

        $type = ucfirst(gettype($avar));
        if($type == "String") $type_color = "<span style='color:green;'>";
        elseif($type == "Integer") $type_color = "<span style='color:red'>";
        elseif($type == "Double"){ $type_color = "<span style='color:#0099c5'>"; $type = "Float"; }
        elseif($type == "Boolean") $type_color = "<span style='color:#92008d'>";
        elseif($type == "NULL") $type_color = "<span style='color:black'>";

        if(is_array($avar))
        {
            $count = count($avar);
                $amess.= "$indent" . ($var_name ? "$var_name => ":"") . "<span style='color:#666666'>$type ($count)</span><br>$indent(<br>";
            $keys = array_keys($avar);
            foreach($keys as $name)
            {
                $value = &$avar[$name];
               $amess.=do_dump_string($value, "['$name']", $indent.$do_dump_indent, $reference);
            }
             $amess. "$indent)<br>";
        }
        elseif(is_object($avar))
        {
             $amess. "$indent$var_name <span style='color:#666666'>$type</span><br>$indent(<br>";
            foreach($avar as $name=>$value)  $amess.=do_dump_string($value, "$name", $indent.$do_dump_indent, $reference);
             $amess. "$indent)<br>";
        }
        elseif(is_int($avar))  $amess.= "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".htmlentities($avar)."</span><br>";
        elseif(is_string($avar))  $amess.=  "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color\"".htmlentities($avar)."\"</span><br>";
        elseif(is_float($avar))  $amess.=  "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".htmlentities($avar)."</span><br>";
        elseif(is_bool($avar))  $amess.=  "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".($avar == 1 ? "TRUE":"FALSE")."</span><br>";
        elseif(is_null($avar))  $amess.=  "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> {$type_color}NULL</span><br>";
        else  $amess.=  "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> ".htmlentities($avar)."<br>";

        $var = $var[$keyvar];
    }

     $amess.=  "</div>";
     return $amess ;
}

//=====================================
// another dump that can be "collapsed" . Each "level" has  clickable link to open up lower levels
// adapted from http://php.net/manual/en/function.var-dump.php#116041
// $input: obbject etc to dump
// $collapse: if true, start with higher level elements collapsed
// For collapse features to work well, we recommend using the    displayElsewhere(aid,atitle,stuff3) js function in wsurveyUtils1.js
// That is, collect the output from this (using php ob_start ... $stuff=ob_get_contents), and call as displayElswere('','some title',$stuff)

function dump_debug($input, $collapse=true,$message='',$levelLabels='') {
    echo "<div title=\"description of variable\" style=\"border:1px solid blue;margin:10px 5em 10px 4em\"> $message </div>\n" ;
//    print "$message ; Xxx $levelLabels <p> ";
    $useLevelLabels=explode(',',$levelLabels);
//      var_dump($useLevelLabels);
    $recursive = function($data, $level=0,&$maxlevel,$useLevelLabels ) use (&$recursive, $collapse ) {
        $maxlevel=max($level,$maxlevel);
        global $argv;


        $isTerminal = isset($argv);

/*
        if (!$isTerminal && $level == 0 && !defined("DUMP_DEBUG_SCRIPT")) {
            define("DUMP_DEBUG_SCRIPT", true);

            echo '<script language="Javascript">function toggleDisplay(id) {';
            echo 'var state = document.getElementById("container"+id).style.display;';
            echo 'document.getElementById("container"+id).style.display = state == "inline" ? "none" : "inline";';
            echo 'document.getElementById("plus"+id).style.display = state == "inline" ? "inline" : "none";';
            echo '}</script>'."\n";
        }
*/

        $type = !is_string($data) && is_callable($data) ? "Callable" : ucfirst(gettype($data));
        $type_data = null;
        $type_color = null;
        $type_length = null;

        switch ($type) {
            case "String":
                $type_color = "green";
                $type_length = strlen($data);
                $type_data = "\"" . htmlentities($data) . "\""; break;

            case "Double":
            case "Float":
                $type = "Float";
                $type_color = "#0099c5";
                $type_length = strlen($data);
                $type_data = htmlentities($data); break;

            case "Integer":
                $type_color = "red";
                $type_length = strlen($data);
                $type_data = htmlentities($data); break;

            case "Boolean":
                $type_color = "#92008d";
                $type_length = strlen($data);
                $type_data = $data ? "TRUE" : "FALSE"; break;

            case "NULL":
                $type_length = 0; break;

            case "Array":
                $type_length = count($data);
        }

        if (in_array($type, array("Object", "Array"))) {
            $notEmpty = false;

            foreach($data as $key => $value) {
                if (!$notEmpty) {
                    $notEmpty = true;

                    if ($isTerminal) {
                        echo $type . ($type_length !== null ? "(" . $type_length . ")" : "")."\n";

                    } else {
                        $id = substr(md5(rand().":".$key.":".$level), 0, 8);

                        echo "<a title=\"level ".$level."\" href=\"javascript:toggleDisplay('". $id ."');\" style=\"text-decoration:none\">";
                        $aclass=' '; $aclassSpan=' ';
                        if ($level>0) $aclass=' class="containers containers_'.$level.' " ' ;
                        if ($level>1) $aclassSpan=' class="containers containers_'.$level.' " ' ;
                        echo "<span  ".$aclassSpan."  title=\"level ".$level."\"  style='color:#666666'>" . $type . ($type_length !== null ? "(" . $type_length . ")" : "") . "</span>";
                        echo "</a>";
                        if ($level>0) {
                            echo "<span   title=\"level ".$level."\" ".$aclassSpan."  id=\"plus". $id ."\" style=\"display: " . ($collapse ? "inline" : "none") . ";\">&nbsp;&#10549;</span>";
                            echo "<div    title=\"level ".$level."\" ".$aclass."   id=\"container". $id ."\" style=\"display: " . ($collapse ? "none" : "inline") . ";\">";
                        } else {
                            echo "<span  title=\"level ".$level."\" ".$aclassSpan."  id=\"plus". $id ."\">&nbsp;&#10549;</span>";
                            echo "<div  title=\"level ".$level."\" ".$aclass."   id=\"container". $id ."\" xstyle=\"display: " . ($collapse ? "none" : "inline") . ";\">";
                       }
                        echo "<br />\n";
                    }

                    for ($i=0; $i <= $level; $i++) {

                       $lab1='|';
                       if ($i==$level) {
                         if (isset($useLevelLabels[$i])) $lab1='<span title="">'.$useLevelLabels[$i].'</span> ' ;
                       }

                        echo $isTerminal ? $lab1."    " : "<span style='color:black'>".$lab1."</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                    }

                    echo $isTerminal ? "\n" : "<br />\n";
                }

                for ($i=0; $i <= $level; $i++) {
                    echo $isTerminal ? "|    " : "<span style='color:black'>|</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                }

                $lab1='';
                if (isset($useLevelLabels[$level])) $lab1='<span style="font-size:60%">'.$useLevelLabels[$level].'</span> ' ;
                echo $isTerminal ? "[" . $lab1. $key . "] => " : "<span style='color:black'>[" . $lab1. $key . "]&nbsp;=>&nbsp;</span>";
                call_user_func($recursive, $value, $level+1,$maxlevel,$useLevelLabels);
            }

            if ($notEmpty) {
                for ($i=0; $i <= $level; $i++) {
                    echo $isTerminal ? "|    " : "<span style='color:black'>|</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                }

                if (!$isTerminal) {
                    echo "</div>  ";
                }

            } else {
                echo $isTerminal ?
                        $type . ($type_length !== null ? "(" . $type_length . ")" : "") . "  " :
                        "<span style='color:#666666'>" . $type . ($type_length !== null ? "(" . $type_length . ")" : "") . "</span>&nbsp;&nbsp; ";
            }

        } else {
            echo $isTerminal ?
                    $type . ($type_length !== null ? "(" . $type_length . ")" : "") . "  " :
                    "<span style='color:#666666'>" . $type . ($type_length !== null ? "(" . $type_length . ")" : "") . "</span>&nbsp;&nbsp;";

            if ($type_data != null) {
                echo $isTerminal ? $type_data : "<span style='color:" . $type_color . "'>" . $type_data . "</span>";
            }
        }

        echo $isTerminal ? "\n" : "<br />  \n";
    };

    call_user_func($recursive, $input,0,0,$useLevelLabels);

}




//---------------
// print an array inbetwee pres
function printPre($arr,$iexit=0) {

  if (!is_array($arr)) {
      print "\n<pre>\n";
      print  $arr;
      print "\n</pre>\n";
      if ($iexit=='1') exit;
      return 0;
  }

  print "\n<pre>\n";
  print_r($arr);
  print "\n</pre>\n";
  if ($iexit=='1') exit;
  return 0;
}




//=============
// find file beginning with $aname in the tree starting with $base (first match is returned)
// if aname=*, find all files  (or first file if nmatches=1)
// if nosub==1, do NOT look in other subdirectories
// for exact match,  set exact=1
// to return array of more than one match, set $nmatches>1... up to $nmatches will be found
//   note nmatches < 2 is treated as 1
// ie: d:/wamp/bin is base and mysqldump. : look for first file that starts with mysqldump. in/under d:/wamp/bin

// return '0' if no match found , or empty  array if nmatches>1
// if "sayError=1", return '0 error message' if no match found

function findInTree($base,$aname,$exact=0,$nmatches=1,$nosub=0,$sayerror=0){
   
  //$base2=$_SERVER['DOCUMENT_ROOT'].'/';
 // echo debug_backtrace()[1]['function'];
 //print "<br>$aname  <br/>In findInTree using $base , $base2 "; 
  if ($base=='') $base=$_SERVER['DOCUMENT_ROOT'].'/';  // look under wamp directory
  $base=trim(str_replace('\\','/',$base));
  if (substr($base,strlen($base)-1)!=='/') $base=$base.'/';
  $exact=trim($exact);
  $nmatches=trim($nmatches);
  $nosub=trim($nosub);
 
  if (is_nan($nmatches) || $nmatches<2) $nmatches=1 ;
 if (file_exists($base)===false) {
    if ($sayerror==1) {
      return '0 No such directory:  '.$base.' (looking for '.$aname.')' ;
    } else {
          return '0' ;
    }
 }
 
  $subdirectories=opendir($base);
  if ($subdirectories===false ) {
    if ($sayerror==1) {
      return '0 Unable to find '.$aname.' (in '.$base.')';
    } else {
          return '0' ;
    }
  }

  $matches=array();
  while (($subdirectory=readdir($subdirectories))!==false){

    $path=$base.$subdirectory;
    if (is_file($path)){
       $fname=basename($path);
       $ll=strlen($aname);

       if ($exact!=='1') {
           if ($aname=='*' || $aname==substr($fname,0,$ll)) {
               if ($nmatches==1) return $path;
               $matches[]=$path;
           }
       } else {
           if ($aname=='*' || $aname==$fname) {
               if ($nmatches==1) return $path;
               $matches[]=$path;
           }
       }

    } else {                     // not a file
       if (($nosub!=='1' && $subdirectory!='.') && ($subdirectory!='..')){      // don't look in . or .., or maybe not in subdirectories at all?
         $aret=findInTree($path.'/',$aname,$exact,$nmatches);

        if ($nmatches==1) {
            if ($aret!='0') return $aret ;
        } else {
           if (count($aret)>0)  $matches=array_merge($matches,$aret);      // continue down tree
        }
      }              // not . or ..
    }            // is_file

    if ($nmatches>1 && count($matches)>=$nmatches) return $matches;


  }              // readir

  if ($nmatches>1) return $matches ;
  return '0';
}




?>