<?php
namespace wSurvey\utilsP ;

/* wsurvey.utilsP : some useful php functions */


// ================
// takes a value from ini_get(), and converts to an integer (i.e.; 8M becomes 8388608)
 function getBytes($val) {
    $val = trim($val);
    preg_match('/([0-9]+)[\s]*([a-zA-Z]+)/', $val, $matches);
    $value = (isset($matches[1])) ? intval($matches[1]) : 0;
    $metric = (isset($matches[2])) ? strtolower($matches[2]) : 'b';
    switch ($metric) {
        case 'tb':
        case 't':
            $value *= 1024;
        case 'gb':
        case 'g':
            $value *= 1024;
        case 'mb':
        case 'm':
            $value *= 1024;
        case 'kb':
        case 'k':
            $value *= 1024;
    }
    return $value;
}

// ------   http://stackoverflow.com/questions/4371059/shorten-long-numbers-to-k-m-b
// convert a nunber to k,m.
// add commas to numberic part. Deafult 1 decimal points of accuracy; switch to K,M,B at >1000, >1million, >1 billion
// ismult is used to set the switch points. I.e.; if ismult=10, then switch at >10k, >10m, and >10G
//           (so 1312 becomes 1,312 while 13124 becomes 13.1K
// you can add stuff before and after the K, etc.
//   pre: add after number and before K,M,G
//  post: add after number and after K,M,G
// Note these are added even for small numbers
// ie: pre=' * ', post=' bytes', then custom_number_format(123456,1,1,'* ','bytes') yields "123.4 * k bytes"
//
// precision is # of decimal points to show. IF a an array (0...3) then # of decmimal points depends on size of value

  function custom_number_format($n, $precision = 1,$ismult=1,$pre='',$post='') {

   $thePrecs=$foo=array_fill(0,4,$precision);      // 0:<1000 *ismult, 1 =< 1,000,000*ismult, 2 <= 100,0000,000 * ismult; 3 > 100,0000,000 * ismult;
    if (is_array($precision))  {    // use precision that depends on value
      for ($i=0;$i<count($thePrecs);$i++) {
          if (array_key_exists($i,$precision) && is_numeric($precision[$i]))  $thePrecs[$i]=intval($precision[$i]);
      }
    }


    if ($n < 1000*$ismult) {           // Anything less than a thousand (add commas)
        $n_format = number_format($n,$thePrecs[0]) . $post ;
    } else if ($n < 1000000*$ismult) {         // lt 1 million, gt 10k
        $n_format = number_format($n / 1000, $thePrecs[1]) . $pre. 'K' . $post ;
    } else if ($n<1000000000*$ismult) {                // gt 1 million lt 10 billion
        $n_format = number_format($n / 1000000, $thePrecs[2]) .  $pre. 'M' . $post ;
    } else {
        $n_format = number_format($n / 1000000000, $thePrecs[3]) .  $pre. 'G' . $post ;
    }
    return $n_format;
}

//======
// display number as 0.zzzz or xe-z (use scientific notation if small number)
function sci_number_format($vs,$iexp=4) {
  $iexp1=max($iexp-1,1);
  $dval=pow(10,-$iexp);   //
     if (trim($vs)==='') return ' ... ';
     if ($vs==0.0) return '0.0' ;
     if ($vs>20) {
       $bb=number_format($vs);
     } else  if ($vs<$dval) {
         $bb=sprintf('%.'.$iexp.'e',$vs) ;
     } else {
           $bb=number_format($vs,$iexp);
     }
     return $bb ;
  }

//======================
// format secons to a dd hh:mm or dd.ee format (dd=days, hh=hours, mm=minutes
// use dd.ee if $noHour=1
// otherwise use hh (acc=1), hh:mm (acc=2) or hh:mm:ss  (otherwise)
function secondsToDays($seconds,$useDec=0,$acc=2){
  $ndays=floor($seconds/86400) ;

  $ss=floor($seconds-($ndays*86400)) ;
  if ($useDec!==1) {                  // conver to hh:mm
    $hours = floor($ss / 3600);
    $mins = floor(($ss - ($hours*3600)) / 60);
    $secs = floor($ss % 60);
    if ($acc==1) {
      $app=" $hours h ";
    } else if ($acc==2) {
         if ($hours<10) $hours='0'.$hours ;
         if ($mins<10) $mins='0'.$mins ;
         $app=" $hours:$mins ";
    } else {
       if ($hours<10) $hours='0'.$hours ;
       if ($mins<10) $mins='0'.$mins ;
       if ($secs<10) $secs='0'.$secs ;
       $app=" $hours:$mins:$secs" ;
    }
    if ($ndays<1) return $app ;
    return "$ndays d $app ";
 }
 $app=$ss/86400 ;
 $app0=$app;

 if ($acc==2) {
    $app=round($app,2);
 } else if ($acc==1) {
    $app=substr($app,0,3);

 } else {
    $app=round($app,3);
 }
 return $ndays+$app;
}

//============
//  http://snipplr.com/view/8659/
function formatScientific($someFloat)       {
        $power = ($someFloat % 10) - 1;
        return ($someFloat / pow(10, $power)) . "e" . $power;
}



// =-========
// http://stackoverflow.com/questions/4763668/php-convert-milliseconds-to-hours-minutes-seconds-fractional
// convert milliseconds to hh:mm:ss.xxx
// To control ss.xxx (milliseconds), use second arguments.  0 means "no .xxx", 1 means ".xxx", 2 means "no ss.xxx"
function formatMilliseconds($milliseconds,$nodec=0) {
    $seconds = floor($milliseconds / 1000);
    $minutes = floor($seconds / 60);
    $hours = floor($minutes / 60);
    $milliseconds = $milliseconds % 1000;
    $seconds = $seconds % 60;
    $minutes = $minutes % 60;

    if ($nodec==2 ){
       $format = '%u:%02u';
       $time = sprintf($format, $hours, $minutes);
    } else {
      if ($nodec==1) {
         $format = '%u:%02u:%02u';
         $time = sprintf($format, $hours, $minutes, $seconds);
      } else {
        $format = '%u:%02u:%02u.%03u';
        $time = sprintf($format, $hours, $minutes, $seconds, $milliseconds);
      }
    }
    return rtrim($time, '0');
}

//==============
// simple string obsfucator and unobsfuctor. Works with similar named functions in wsurveyUtils1.js
// THis can be used to obsfucate strings sent to javascript (and back again). 
// It really is NOT an encryption, but might stop idle snoops (i.e.; those looking at source code of html documents)

function obsfucate($astring) {
    $a1=base64_encode($astring);
    $a2=str_replace('=','$',$a1);
    $a3=str_rot13($a2);
    return $a3 ;
}
function unobsfucate($astring) {
    $a1=str_rot13($astring);
    $a2=str_replace('$','=',$a1);
    $a3=base64_decode($a2);
    return $a3 ;
}



//====================================
//truncate string to at most mxlen bytes. multibyte safe.
// kind of clunky, but works
function mb_truncString($avar,$mxlen=250,$adef='') {
    $nmax=mb_strlen($avar,'UTF-8');
    for ($ilen=$nmax;$ilen>0;$ilen--) {
       $atry=mb_substr($avar,0,$ilen);
       if (strlen($atry)<$mxlen) return $atry;
   }
  return $adef ;  //  only happens if short mxlen and mb first char
}

//===========
// encrypt and decrypt intger values.
// based on https://stackoverflow.com/questions/24350891/how-to-encrypt-decrypt-an-integer-in-php/24350928
//
// useage:
//   $encryptedNumber=NumHash::encrypt($danum,$keyString);
//   $decrtypedNumber=NumHash::decroypt($encryptedNumber,$keyString);
// md5 of keystring is used.
// encryptedNumber will be an integer (32 or 64 bit, dep
// Examples:
// NumHash::encrypt(0,'abcd1234')  ==>   61626364313233342
// NumHash::encrypt(10,'abcd1234')  ==>  58811614546126782
// NumHash::encrypt(-12,'abcd1234')  ==>   -59093089522837439
// NumHash::encrypt(512512,'abcd1234')  ==>   -3253022961431451719
//
// NumHash::decrypt(61626364313233342 ,'abcd1234')  ==>   0
// NumHash::decrypt(58811614546126782 ,'abcd1234')  ==>  10
// NumHash::decrypt(-59093089522837439,'abcd1234')  ==>   -12
// NumHash::eecrypt( -3253022961431451719,'abcd1234')  ==>   512512
//
// Note: checks if 32 or 64 bit integers, and encrypts/dectrypts accordingly

class NumHash {

// private static $SALT = 0xd0c0adbf;   // from original code

  public static function encrypt($n,$mysalt0='salt') {
      if (!is_numeric($n)) return NAN ;
    $isize=PHP_INT_SIZE ;
    $mysalt1= md5($mysalt0) ;
    $sub8=substr($mysalt1,0,8);
    if ($isize==4) $sub8=substr($mysalt1,0,8);
    if ($isize==8) $sub8=substr($mysalt1,0,16);

    $mysalt=hexdec($sub8);

//    if ($isize==4) $mysalt=substr($mysalt1,0,8);
//    if ($isize==8) $mysalt=substr($mysalt1,0,16);
//   print gettype($mysalt)." ($mysalt)";
    return ($isize  == 4 ? self::encrypt32($n) : self::encrypt64($n)) ^ $mysalt;
  }

  public static function decrypt($n,$mysalt0='salt') {
    $isize=PHP_INT_SIZE ;
    $mysalt1= md5($mysalt0) ;
    if ($isize==4) $sub8=substr($mysalt1,0,8);
    if ($isize==8) $sub8=substr($mysalt1,0,16);
    $mysalt=hexdec($sub8);
    $n ^= $mysalt;
    return $isize== 4 ? self::decrypt32($n) : self::decrypt64($n);
  }

  public static function encrypt32($n) {
    return ((0x000000FF & $n) << 24) + (((0xFFFFFF00 & $n) >> 8) & 0x00FFFFFF);
  }

  public static function decrypt32($n) {
    return ((0x00FFFFFF & $n) << 8) + (((0xFF000000 & $n) >> 24) & 0x000000FF);
  }

  public static function encrypt64($n) {
    return ((0x000000000000FFFF & $n) << 48) + (((0xFFFFFFFFFFFF0000 & $n) >> 16) & 0x0000FFFFFFFFFFFF);
  }

  public static function decrypt64($n) {
    return ((0x0000FFFFFFFFFFFF & $n) << 16) + (((0xFFFF000000000000 & $n) >> 48) & 0x000000000000FFFF);
  }
}

//==========
//https://php.net/manual/en/function.array-multisort.php
//  
//   $newArray=array_msort($array,$colSortInstructions,$sortType)
// 
//   where
//      $array: the associative array to sort
//      $colSortInstructions: an associative array congaining instructions on how to sort $array -- which columns to sort on first, in what order
//                              Each element in this array is  'colName'=>sortOrder
//                              sortOrder is either SORT_ASC or SORT_DESC (php constants, so do NOT preced with a $)
//      $sortType: optional. The type of sort (string, numeric, etc)
//         This can be one of: SORT_REGULAR, SORT_NUMERIC, SORT_STRING, SORT_LOCALE_STRING, SORT_NATURAL, SORT_FLAG_CASE
//          (SORT_FLAG_CASE can be OR with SORT_STRING or SORT_NATURAL)
//      If not specified, SORT_REGULAR is used
//
//  Returns sorted array. Thus, $array is NOT changed.
//
//  Example (assumes $arr1 had an 'id1' and 'id2' colum, perhaps other columns also
//       $newarrray=array_msort($arr1, array('id1'=>SORT_DESC, 'id2'=>SORT_ASC'],SORT_STRING);
//
//  Sorted in order of indices. So first sort on "id1", and then within blocks of data with the same value of 'id1', sort by 'id2'
//
// See php array_multisort for descriptiong of the sortOrder and sortType options

function array_msort($array, $cols,$sortType=SORT_REGULAR,$debug=0) {
    $colarr = array();
    foreach ($cols as $col => $order) {
        $colarr[$col] = array();
//        foreach ($array as $k => $row) { $colarr[$col]['_'.$k] = strtolower($row[$col]); }
        foreach ($array as $k => $row) {
            $colarr[$col]['_'.$k] = $row[$col] ;
        }
    }
    $eval = 'array_multisort(';
    foreach ($cols as $col => $order) {
        $eval .= '$colarr[\''.$col.'\'],'.$order.','.$sortType.',';
    }
    $eval = substr($eval,0,-1).');';

    if ($debug== 1) {
      print '<BR>SORT_ASC='.SORT_ASC.', SORT_DESC= '.SORT_DESC.' ,  SORT_NUMERIC ='.SORT_NUMERIC.', SORT_REGULAR= '.SORT_REGULAR.', SORT_STRING='.SORT_STRING ;
      print '<div style="overflow:scroll;xheight:14em">';
      print '<br>original ';
      do_dump($array);
      print '<br> sort instructions ';
      do_dump($colarr);
      print '<br>the call ';
      do_dump($eval);
     }

    eval($eval);
    $ret = array();
    foreach ($colarr as $col => $arr) {
        foreach ($arr as $k => $v) {
            $k = substr($k,1);
            if (!isset($ret[$k])) $ret[$k] = $array[$k];
            $ret[$k][$col] = $array[$k][$col];
        }
    }

    if ($debug== 1) {
       print '<br>Sorted ';
       do_dump($ret);
       print '</div>';
       exit;
    }

    return $ret;

}



//========
//https://stackoverflow.com/questions/478121/how-to-get-directory-size-in-php
//  directory: path to director
// doSUbs= 1 (or default) -- all subdirectories, otherwise skip subdirectoires
function get_dir_size($directory,$doSubs=1){
    $size = 0;
    $doSubs=trim($doSubs);
    $alast=substr($directory,-1);
    if ($alast=='/' || $alast=="\\") {
      $adir=$directory.'*';
    } else {
        $adir=$directory.'/*';
    }
    $files = glob($adir);
    foreach($files as $path){
        is_file($path) && $size += filesize($path);
        if (is_dir($path) && $doSubs=='1') {
           $size += get_dir_size($path,$doSubs);
        }
    }
    return $size;
}


//===============================
//Loosely based on https://stackoverflow.com/questions/478121/how-to-get-directory-size-in-php
// return array with all subdirectories under $directory.
// 0th element is self.
//   [original path, fully qualified original path]
//   where original path is what is specified (it might be a relative path)
//   If there is NOT such path, a 1 element [0] array is returned.
//      If fullpath=1 : [0]=false
//      If fullpath=2  [0]=[original path,false]
//     othe [1] arg (fully qu...) will be false.  So check there for failure
// Does not include . or ..   subdirectories
//
// called as: get_subdir_ist($directory,$fullpath)
//
// $directory: fully qualified path
//      If not fully qualified (does NOT begin with x:/ or with /) is relative to the current directory (getCwd())
//
//    fullpath:0, 1, 2 (default is 1)
//       0  = return relative path (relative to directory). Does NOT start with a /
//       1 = fullpath (the default)
//       2 =  both in a 2 element array {fullpath,relpath]
//  Note that in all cases, \ are converted to /. And never ends in a /
//
// Note:
//  sublist arg used internally. On first call, leave it out or specify 0.
//     Or, to build on a prior list, specify the prior return from get_subdir_list
//   origPathLen arg is used internally.  Do not specify!  Or specify as 0 if you must

function get_subdir_list($directory,$fullpath=1,&$sublist=[],$origPathLen=0){
    if (func_num_args()<3 || $sublist===0  || $sublist==='0' || $sublist==='') $sublist=[];  // initializse
    $directory=trim($directory);
    $directory=str_replace('\\','/',$directory);
    $directory=rtrim($directory,'/');
    $adir=$directory.'/*';  // avoid . and ..
    if ($origPathLen==0 ) {
       $origPathLen=strlen($directory) ;
       $origFullPath= realpath($directory);
       $origFullPath= str_replace('\\','/',$origFullPath);
        if ($fullpath==0) {
              $sublist[]= $directory;
           } else if ($fullpath==2) {
              $sublist[]=[$directory,$origFullPath] ;
           } else  {  // all else is full path
              $sublist[]= $origFullPath ;
           }
    }
    $files = glob($adir);
    foreach($files as $path){
        if (is_dir($path)) {
           if ($fullpath==0) {
              $sublist[]= substr($path,$origPathLen+1) ;
           } else if ($fullpath==2) {
              $sublist[]=[realpath($path),substr($path,$origPathLen+1)];
           } else  {  // all else is full path
              $sublist[]= realpath($path);
           }
           get_subdir_list($path,$fullpath,$sublist,$origPathLen);
        }
    }
    return $sublist;
}

//===
// for details, see wsurvey.lib/docs (wsurvey.utilsP.php)

function get_subdir_list($directory,$fullpath=1,&$sublist=[],$origPathLen=0){
    if (func_num_args()<3 || $sublist===0  || $sublist==='0' || $sublist==='') $sublist=[];  // initializse
    $directory=trim($directory);
    $directory=str_replace('\\','/',$directory);
    $directory=rtrim($directory,'/');
    $adir=$directory.'/*';  // avoid . and ..
    if ($origPathLen==0 ) {
       $origPathLen=strlen($directory) ;
       $origFullPath= realpath($directory);
       $origFullPath= str_replace('\\','/',$origFullPath);
        if ($fullpath==0) {
              $sublist[]= $directory;
           } else if ($fullpath==2) {
              $sublist[]=[$directory,$origFullPath] ;
           } else  {  // all else is full path
              $sublist[]= $origFullPath ;
           }
    }
    $files = glob($adir);
    foreach($files as $path){
        if (is_dir($path)) {
           if ($fullpath==0) {
              $sublist[]= substr($path,$origPathLen+1) ;
           } else if ($fullpath==2) {
              $sublist[]=[realpath($path),substr($path,$origPathLen+1)];
           } else  {  // all else is full path
              $sublist[]= realpath($path);
           }
           get_subdir_list($path,$fullpath,$sublist,$origPathLen);
        }
    }
    return $sublist;
}


//===-
// extract request variables whose case-insensitve name starts with a string
// return a N row array, each row has  NAME, MATCH, and VALUE
//  name: full name of request var
//  match: part after the searchFor
//  value : value of request var
// example:
// request string  v_11=101&v_13=1671&foo=help
//  $vv=extractRequestVars('V_');
// $vv will have 2 rows (N=2) with values:
//  [0][NAME]='V_11', [0][MATCH]='11', [0]['VALUE']=101
//  [1][NAME]='V_13', [1][MATCH]='13'  [1]['VALUE']=167
// if no match, an empty array is returned

function extractRequestVars($searchfor) {
  $searchfor=strtoupper($searchfor);

$matches1=array();
foreach ($_REQUEST as $vname=>$oof) {
//print "<br>Look at $vname is $oof";
     $avar=trim(strtoupper($vname)) ;
     $sfor='/\A'.$searchfor.'(.*)/';
     $nn=preg_match($sfor,$avar,$matches);
//     print " sfor=$sfor in $avar, nn=$nn ".count($matches);

     if (count($matches)>0) {
//       print " == Match <br> $avar";
        $matches1[]=array('NAME'=>$matches[0],'MATCH'=>$matches[1],'VALUE'=>$oof);
     }
}
return $matches1 ;

}

//===-
// extract a request field (GET or POST)
// varname is name of field to get. can be a space delimited list of names (first one found is returned)
// if $errormess='', return $default if no such field
//    if = '1',  display generic error  message and exit
//    else, display $errormess and exit
function extractRequestVar($varname,$default='0',$errorMess='') {
$varname=trim(strtoupper($varname));
$vars =getWords($varname);


// preg_replace("/\s+/"," ", $varname) ;             // collapse spaces
//$varname=strtoupper(trim($varname));
//$vars=explode(' ',$varname);

foreach ($_REQUEST as $vname=>$oof) {
     $avar=trim(strtoupper($vname)) ;
     for ($ith=0;$ith<count($vars);$ith++) {
        if ($avar==$vars[$ith]) {
           return $oof ;
        }
     }
}
// if here, could not be found

$errorMess=trim($errorMess);
if ($errorMess!=='') {          // an error, quit      -- sep 2014 note: on too large file uploads, you might get this error (buffer overwrite?)
  if ($errorMess=='1') {
     $file = $_SERVER["SCRIPT_NAME"];
      $break = explode('/', $file);
      $pfile = $break[count($break) - 1];
//      ob_get_clean() ;

//      header("Content-Type: text/plain");
      print "\n";
      print '- Error. not able to find request variable (' . $varname . ') in ' . $pfile ;
      if (count($_REQUEST)==0) {
         print '   <br>Note: the $_REQUEST parameter is empty. This is often a sign of an upload that exceeds server limits. '  ;
      }
  } else {
     header("Content-Type: text/plain");
     print $errorMess ;
  }
  exit ;
}

 return $default ;
}

//=============
// trim spaces, convert internal spaces to single space string, break into an array
// if docomma=1, treat commas and tabs and new lines as spaces
function getWords($cval3,$docomma=0) {
    $cval3=trim($cval3);
    if ($docomma==1) {
      $cval4=preg_replace("/[\t\n\r\s,]+/"," ", $cval3) ;             // collapse spaces and other seperators
    } else {
      $cval4=preg_replace("/\s+/"," ", $cval3) ;             // collapse spaces
    }
    $bvars=explode(' ',$cval4) ;
    return $bvars ;

}
// http://stackoverflow.com/questions/5956610/how-to-select-first-10-words-of-a-sentence
function getwordsN( $str, $wordCount = 100000 ) {
  return implode(
    '', 
    array_slice( 
      preg_split(
        '/([\s,\.;\?\!]+)/', 
        $str,
        $wordCount*2+1, 
        PREG_SPLIT_DELIM_CAPTURE
      ),
      0,
      $wordCount*2-1
    )
  );
}


//=========================
// do the nth stuff
function nthValue($aval,$useword='0') {

//          <? $_nth 0> -- 0th
//          <? $_nth 1> -- 1st
//          <? $_nth 2> -- 2nd
//          <? $_nth 3> -- 3rd
//          <? $_nth 4> to <? $_nth 20>  -- 4th,...,20th
//          <? $_nth 21> -- 21st
//          <? $_nth 22> -- 22nd
//          <? $_nth 23> -- 23rd
//          <? $_nth 24> <? $_nnth 30> -- 24th, ..., 30th


$v1=array('0th','1st','2nd','3rd','4th','5th','6th','7th','8th','9th','10th','11th','12th');
$v2=array('zeroth','first','second','third','fourth','fifth','sixth','seventh','eighth','nineth','tenth','eleventh','twelth');

$isneg='';
if ($aval<0) {
   $isneg='-';
   $aval=-$aval;
}
//$aval=number_format($aval);
if ($aval<13) {
    if ($useword=='1') {
       return $isneg.$v2[$aval] ;
    } else {
       return $isneg.$v1[$aval];
    }
}

// large value (don't return as word)
$arem=$aval % 10 ;
if ($arem==1) return $isneg.$aval.'st';
if ($arem==2) return $isneg.$aval.'nd';
if ($arem==3) return $isneg.$aval.'rd';

return $isneg.$aval.'th';                          // otherwise

}



//================
// extract columns from an array-of-arrays
// return each column as a row
// if only one column requested, return as a simple array
// if more than one, return as an associative array, with each row using (indexed with column name) containing contents of the column (as an indexed array)
//  $cols = extractCol($vv,$vars)
//     $vv  = the array of arrays
//     $vars  = space delimited list of columns to extract
//     $cols = array of values of desired column (or associative array with each row an indexed array)
//  Example: a $vv array, with rows; each row an associative array with 3 values
//  row  NAME   AGE  WEIGHT
//  1   Joe     51   156
//  2   Susan    61  122
//  3  Bill      33  184
//  4   Bob      12   93
//$foo=extractCol($vv,'AGE');
//  would return a 4 element array: $foo[0]=51  $foo[1]=61   $foo[2]=33   $foo[3]=12
//$foo=extractCol($vv,'AGE NAME');
//  would return a 2 element associative array, each element being an array:
//       $foo['AGE'][0]=51  $foo['AGE'][1]=61   $foo['AGE'][2]=33   $foo['AGE'][3]=12
//       $foo['NAME'][0]='Joe'  $foo['NAME'][1]='Susan'   $foo['NAME'][2]='Bill'  $foo['NAME'][3]='Bob'
// Note:  if a variable does NOT exist in a row (say, the associative arrays don't always contain the same set of indices), that value is a null
//        Thus, asking for a non-existent variable yields an array of nulls
//        If no variables specified, return empty array. If $vv is empty, return empty array
//        Variable names are case sensitive!

function extractCols($vv,$vars,$noerr=0) {

  $stuff=array();
  $stuff2=array();

  $vars=trim($vars);
  if ($vars=='') return $stuff2 ;

  $vlist=getWords($vars);
  if (count($vv)==0) return $stuff2 ;             // empty, so return empty

  for ($iv=0;$iv<count($vlist);$iv++) {
    $avar=$vlist[$iv];
    $stuff=array();
    for ($iss=0;$iss<count($vv);$iss++)  {
        if (isset($vv[$iss][$avar])) {
           $stuff[]=$vv[$iss][$avar];
        } else {
           $stuff[]=null;
        }
    }
    if (count($vlist)==1) return $stuff;
    $stuff2[$avar]=$stuff;
  }
  return $stuff2 ;
}


//===============================
// extract 1 column from a multid array
function extract1Col($varray,$aname,$adefault=null) {
$alist=array();
$aname=trim($aname);
for ($m=0;$m<count($varray);$m++)  {
  $r1=$varray[$m];
  $aval=$adefault ;
  if (isset($r1[$aname])) $aval=$r1[$aname];
  $alist[]=$aval;
}
return $alist;
}



//===================================
//http://php.net/manual/en/function.nl2br.php
// replace <br> with crlf

function br2nl ( $string, $separator = PHP_EOL ){
    $separator = in_array($separator, array("\n", "\r", "\r\n", "\n\r", chr(30), chr(155), PHP_EOL)) ? $separator : PHP_EOL;  // Checks if provided $separator is valid.
    return preg_replace('/\<br(\s*)?\/?\>/i', $separator, $string);
}

//=================
// strip active tags, and "label"  links -- returns as a string.
// this can work with  html fragments
// it uses php's DOMDocument
// aclass" to add to links (to disable). If not specified "htmlDisablerC" is used. If '1',  style="border-bottom:blue; color:blue" is used instead of as style
//         use of a class allows a click handler to be added (such html_element_disabler_action) -- that can give users the ability to go there anywans
// aTitle: to add to links. If not specified "This link has been disabled" is used (added to exsiting title)
// badTags : list of tags to remvove. Default is many "possibly active/dangerous" tags. If specified, us a CSV (no spaces). Lower case!   If '1' or '0', do the default
//  whatdo: B L or E (both, links only, elements only)
//
// returns:   return [newText,# links disabled,# elems removed,elements removed by type  as csv
// the elems removed has syntax:  tag n,tag n,...
//  i.e.;  head 1, object 1, script 3
//
// Warning: removal of <head> can be buggy. If there is any content within <head> .. </head>, but not in some other tag, it may not be removed.

function html_element_disabler($text,$aclass="htmlDisablerC",$atitle='This link has been disabled',$badTags0='head,script,noscript,Style,embed,object,applet,noframes,frame,noscript',$whatDo='B') {

 $badTags0=trim($badTags0);
 $removeTags=['script','embed','object','applet','head','style','noframes','frame','noscript'];    // default "dangerous" tags to remove
 if (strlen($badTags0)>0 && $badTags0!='1' && $badTags0!='0') {                  // list of tags to remove specified
     $removeTags=[];
     $badTags=explode(',',$badTags0);
     foreach ($badTags as $ii=>$atag) {
         $removeTags[]=trim(strtolower($atag));
     }
  }
  if ($aclass=='0') $aclass='htmlDisablerC';
  if ($atitle=='0')  $atitle='This link has been disabled';

  $aclass=trim($aclass);     $atitle=trim($atitle);

  $whatDo=substr(strToUpper($whatDo),0,1);  // L, E, or B (if not one of these, use B)

  $doc = new DOMDocument;           // create object to work with html string. set some attributes
  $doc->preserveWhiteSpace = true;
  $doc->formatOutput=true;
  $doc->validateOnParse=false;
  $doc->standalone=true;

  $text2='<div>'.$text.'</div>';   // used to get rid of stuff added by DOME

  $doc->loadHTML($text2,LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD|LIBXML_NOWARNING|LIBXML_NOERROR);

// disable links
  $nlinks=0;
  if ($whatDo!='E') {                         // NOT "elements only"
   foreach($doc->getElementsByTagName('a') as $link) {         // disable all links
     $alink= $link->getAttribute('href');
     $link->removeAttribute('href');
     $link->setAttribute('disabled_href',$alink);
     if ($link->hasAttribute('title')) {            // append pre existing title to atitle
         $wastitle=$link->getAttribute('title');
         $wastitle=$atitle.'. '.$wastitle  ;
     } else {                      // no preexisting title
         $wastitle=$atitle;
     }
     $link->setAttribute('title',$wastitle);
     if ($aclass=='1') {
        $link->setAttribute('style','color:blue;border-bottom:blue');
     } else  {
        $link->setAttribute('class',$aclass);
     }
     $nlinks++ ;
   }
  }

// remove "badTag" elements
  $nremoves=0;
  $aremoves=[];
  $asay='';
  if ($whatDo!=='L') {                       // NOT "links only"
  foreach ($removeTags as $itt=>$atag ) {              // remove "dangerous" elements
    $elements = $doc->getElementsByTagName($atag);
    $ndo=0;
    for ($i = $elements->length; --$i >= 0; ) {   // remove this elsmenet    -- go backwards to avoid failure!
      $isay=$i+1;
       $aelem = $elements->item($i);

       $foo=$doc->saveHTML($aelem);
       $bRemoved=strlen($foo);
       $acomment=$doc->createComment(' '.$atag.'  element  #'.$isay.' removed ('.$bRemoved.')');
       $aelem->parentNode->insertBefore($acomment,$aelem);
       $aelem->parentNode->removeChild($aelem);
       if (!isset($aremoves[$atag])) $aremoves[$atag]=0;
       $aremoves[$atag]++    ;
       $nremoves++;
    }
  }  // for ech removetags
 
  $asays=[];
  foreach ($aremoves as $ann=>$avv) $asays[]=$ann.' '.$avv;
  $asay=implode(',',$asays);
  }

  $aa=substr($doc->saveHTML($doc->getElementsByTagName('div')->item(0)), 5, -6)   ;  // from 5th char to 6th from end  -- works with <div> hack above!
  return [$aa,$nlinks,$nremoves,$asay]  ;

}
/* Note that this regex seems to identify <a and their Href and contents. this seems to work (at least it finds stuff,, but regex is always suspect ?
regex='|<a\s+.*href="([^"]*)"[^>]*>([^<]*)</a[^>]*>|i';
howmany = preg_match_all($regex,$string,$res,PREG_SET_ORDER|PREG_OFFSET_CAPTURE);
You can then parse the staring, using the pointers and text
*/

//=======
// return full url to the current script. detected if http: or https, adds port, etc
// does NOT include stuff after ?
// from https://stackoverflow.com/questions/6768793/get-the-full-url-in-php
function getCurrentUrl($noQuery=1)       {
    $s = &$_SERVER;
    $ssl = (!empty($s['HTTPS']) && $s['HTTPS'] == 'on') ? true:false;
    $sp = strtolower($s['SERVER_PROTOCOL']);
    $protocol = substr($sp, 0, strpos($sp, '/')) . (($ssl) ? 's' : '');
    $port = $s['SERVER_PORT'];
    $port = ((!$ssl && $port=='80') || ($ssl && $port=='443')) ? '' : ':'.$port;
    $host = isset($s['HTTP_X_FORWARDED_HOST']) ? $s['HTTP_X_FORWARDED_HOST'] : (isset($s['HTTP_HOST']) ? $s['HTTP_HOST'] : null);
    $host = isset($host) ? $host : $s['SERVER_NAME'] . $port;
    $uri = $protocol . '://' . $host . $s['REQUEST_URI'];
    if ($noQuery) {       // strip out stuff after ?
      $segments = explode('?', $uri, 2);
      $url = $segments[0];
    } else {
      $url=$uri;
    }
    return $url;
}

//=============
// match extension to mimetype. Not necessarily dependable, but good for guessing
//https://gist.github.com/raphael-riel/1253986
function extToMimetype($aext) {
  if (substr($aext,0,1)=='.') $aext=substr($aext,1);
  $types = array(
    'ai'      => 'application/postscript',
    'aif'     => 'audio/x-aiff',
    'aifc'    => 'audio/x-aiff',
    'aiff'    => 'audio/x-aiff',
    'asc'     => 'text/plain',
    'atom'    => 'application/atom+xml',
    'au'      => 'audio/basic',
    'avi'     => 'video/x-msvideo',
    'bcpio'   => 'application/x-bcpio',
    'bin'     => 'application/octet-stream',
    'bmp'     => 'image/bmp',
    'cdf'     => 'application/x-netcdf',
    'cgm'     => 'image/cgm',
    'class'   => 'application/octet-stream',
    'cpio'    => 'application/x-cpio',
    'cpt'     => 'application/mac-compactpro',
    'csh'     => 'application/x-csh',
    'css'     => 'text/css',
    'csv'     => 'text/csv',
    'dcr'     => 'application/x-director',
    'dir'     => 'application/x-director',
    'djv'     => 'image/vnd.djvu',
    'djvu'    => 'image/vnd.djvu',
    'dll'     => 'application/octet-stream',
    'dmg'     => 'application/octet-stream',
    'dms'     => 'application/octet-stream',
    'doc'     => 'application/msword',
    'dtd'     => 'application/xml-dtd',
    'dvi'     => 'application/x-dvi',
    'dxr'     => 'application/x-director',
    'eps'     => 'application/postscript',
    'etx'     => 'text/x-setext',
    'exe'     => 'application/octet-stream',
    'ez'      => 'application/andrew-inset',
    'gif'     => 'image/gif',
    'gram'    => 'application/srgs',
    'grxml'   => 'application/srgs+xml',
    'gtar'    => 'application/x-gtar',
    'hdf'     => 'application/x-hdf',
    'hqx'     => 'application/mac-binhex40',
    'htm'     => 'text/html',
    'html'    => 'text/html',
    'ice'     => 'x-conference/x-cooltalk',
    'ico'     => 'image/x-icon',
    'ics'     => 'text/calendar',
    'ief'     => 'image/ief',
    'ifb'     => 'text/calendar',
    'iges'    => 'model/iges',
    'igs'     => 'model/iges',
    'jpe'     => 'image/jpeg',
    'jpeg'    => 'image/jpeg',
    'jpg'     => 'image/jpeg',
    'js'      => 'application/x-javascript',
    'json'    => 'application/json',
    'kar'     => 'audio/midi',
    'latex'   => 'application/x-latex',
    'lha'     => 'application/octet-stream',
    'lzh'     => 'application/octet-stream',
    'm3u'     => 'audio/x-mpegurl',
    'man'     => 'application/x-troff-man',
    'mathml'  => 'application/mathml+xml',
    'me'      => 'application/x-troff-me',
    'mesh'    => 'model/mesh',
    'mid'     => 'audio/midi',
    'midi'    => 'audio/midi',
    'mif'     => 'application/vnd.mif',
    'mov'     => 'video/quicktime',
    'movie'   => 'video/x-sgi-movie',
    'mp2'     => 'audio/mpeg',
    'mp3'     => 'audio/mpeg',
    'mpe'     => 'video/mpeg',
    'mpeg'    => 'video/mpeg',
    'mpg'     => 'video/mpeg',
    'mpga'    => 'audio/mpeg',
    'ms'      => 'application/x-troff-ms',
    'msh'     => 'model/mesh',
    'mxu'     => 'video/vnd.mpegurl',
    'nc'      => 'application/x-netcdf',
    'oda'     => 'application/oda',
    'ogg'     => 'application/ogg',
    'pbm'     => 'image/x-portable-bitmap',
    'pdb'     => 'chemical/x-pdb',
    'pdf'     => 'application/pdf',
    'pgm'     => 'image/x-portable-graymap',
    'pgn'     => 'application/x-chess-pgn',
    'png'     => 'image/png',
    'pnm'     => 'image/x-portable-anymap',
    'ppm'     => 'image/x-portable-pixmap',
    'ppt'     => 'application/vnd.ms-powerpoint',
    'ps'      => 'application/postscript',
    'qt'      => 'video/quicktime',
    'ra'      => 'audio/x-pn-realaudio',
    'ram'     => 'audio/x-pn-realaudio',
    'ras'     => 'image/x-cmu-raster',
    'rdf'     => 'application/rdf+xml',
    'rgb'     => 'image/x-rgb',
    'rm'      => 'application/vnd.rn-realmedia',
    'roff'    => 'application/x-troff',
    'rss'     => 'application/rss+xml',
    'rtf'     => 'text/rtf',
    'rtx'     => 'text/richtext',
    'sgm'     => 'text/sgml',
    'sgml'    => 'text/sgml',
    'sh'      => 'application/x-sh',
    'shar'    => 'application/x-shar',
    'silo'    => 'model/mesh',
    'sit'     => 'application/x-stuffit',
    'skd'     => 'application/x-koan',
    'skm'     => 'application/x-koan',
    'skp'     => 'application/x-koan',
    'skt'     => 'application/x-koan',
    'smi'     => 'application/smil',
    'smil'    => 'application/smil',
    'snd'     => 'audio/basic',
    'so'      => 'application/octet-stream',
    'spl'     => 'application/x-futuresplash',
    'src'     => 'application/x-wais-source',
    'sv4cpio' => 'application/x-sv4cpio',
    'sv4crc'  => 'application/x-sv4crc',
    'svg'     => 'image/svg+xml',
    'svgz'    => 'image/svg+xml',
    'swf'     => 'application/x-shockwave-flash',
    't'       => 'application/x-troff',
    'tar'     => 'application/x-tar',
    'tcl'     => 'application/x-tcl',
    'tex'     => 'application/x-tex',
    'texi'    => 'application/x-texinfo',
    'texinfo' => 'application/x-texinfo',
    'tif'     => 'image/tiff',
    'tiff'    => 'image/tiff',
    'tr'      => 'application/x-troff',
    'tsv'     => 'text/tab-separated-values',
    'txt'     => 'text/plain',
    'ustar'   => 'application/x-ustar',
    'vcd'     => 'application/x-cdlink',
    'vrml'    => 'model/vrml',
    'vxml'    => 'application/voicexml+xml',
    'wav'     => 'audio/x-wav',
    'wbmp'    => 'image/vnd.wap.wbmp',
    'wbxml'   => 'application/vnd.wap.wbxml',
    'wml'     => 'text/vnd.wap.wml',
    'wmlc'    => 'application/vnd.wap.wmlc',
    'wmls'    => 'text/vnd.wap.wmlscript',
    'wmlsc'   => 'application/vnd.wap.wmlscriptc',
    'wrl'     => 'model/vrml',
    'xbm'     => 'image/x-xbitmap',
    'xht'     => 'application/xhtml+xml',
    'xhtml'   => 'application/xhtml+xml',
    'xls'     => 'application/vnd.ms-excel',
    'xml'     => 'application/xml',
    'xpm'     => 'image/x-xpixmap',
    'xsl'     => 'application/xml',
    'xslt'    => 'application/xslt+xml',
    'xul'     => 'application/vnd.mozilla.xul+xml',
    'xwd'     => 'image/x-xwindowdump',
    'xyz'     => 'chemical/x-xyz',
    'zip'     => 'application/zip'
  );
  $aextC=trim(strtolower($aext)) ;
  if (!array_key_exists($aextC,$types)) return "application/octet-stream";
  return $types[$aextC] ;
}



?>