/* javascript functions to support HTML5 "javascript available" file uploads

Note: requires the wsurvey.utils1.php library.

These functions simplify file uploads using <input type="file" ...>, and dropzones, and other!

They are designed to make the contents of a file upload  accessible to javascript functions.
In particular, suppose you wish to use ajax to transfer the contents of files to a php script; rather than using a <form>.
In such a case, you will need to explicitily access the contents of a file upload.
These functions make that easy.

Features:
   simple means of echoing a file back -- including strings created dynamically. And multiple files
   will be returned as a .zip

   Build a list of files, and selectively delete from this list. Or clear the entire list

   Preview what will be sent

   Simple specification: event handler assignations is a simple as specifying ids to standard "file upload" HTML elements

For an example of usage, see wsurvey.uploadFiles_demo.php.

See wsurvey.uploadFiles.txt for documentation

==== */

if (typeof(wsurvey)=='undefined')  {
    var wsurvey={};
}
wsurvey.uploadFiles={};
wsurvey.uploadFiles.setFuncs={};
wsurvey.uploadFiles.submit={};
wsurvey.uploadFiles.adv={};

//==============================
// Initializes a number of  elements (adding event handlers).
//
// uploadDataName is an identifier -- it is where information is stored (in $(document).data()) that is used to upload.
//    you can use '1' to use the default
//  Or if you might have several independent 'upload file' elements, specify differnt uploadData for
//  each of these 'independent' elements
//
 // optionsArg can contains:
// uploadData is required : a string that identifies where to store upload data (in  $(document).data())
//     Deraults (if '',1,or 0) : use 'wsurvey_uploadFiles_info'
//     For most cases the default is best. However, if you might have seperate pathways for uploading files
//      you can specifi a unique "uploadData" for each pathway. Just be sure to use the correct uploadData in
//      calls to wsurvey.uploadFiles functions
//  Options should be specified. It can contain the following fields (if not specified, defaults are used for a field),
//  where field are specified using the usual notation {'fieldName':avalue,'fieldName2':'avalue2',...}
// Supported fields;
//  button drop textarea    submit echoback   summary clear
//  maxFiles  upload_max_filesize  post_max_size memory_limit
//  php callback  callbackClear     echoback_auto  upload_auto


wsurvey.uploadFiles.setup=function(uploadDataName,optionsArg) {

   if (!(window.File && window.FileReader && window.FileList && window.Blob)) {       // html5 file support?
      alert('Sorry, html5 not detected. Dynamic (ajax) file uploads not supported ');
      return 0;
   }

   if (arguments.length<1) {
          alert('wsurvey.uploadFiles.setup: no arguments specified');
          return 0;
   }
   var miscInfo={};                                    // jQUery objects: ['upload'] also saved (self refernetial as it may be)
   miscInfo['drop']=false;           // drag and drop "element"
   miscInfo['button']=false;        //  input type="button" element
   miscInfo['textarea']=false;       // string from textarea ( using .val())
   miscInfo['summary']=false;    // where status of file selection is displayed.
   miscInfo['submit']=false;      // element  that will submit when clicked -- it calls wsurvey.uploadFiles..upload()
   miscInfo['echoback']=false;      // element  that will submit-for-echoback when clicked -- it calls wsurvey.uploadFiles.submit.echoback()
   miscInfo['clear']=false;      // element  that will clear various areas

   miscInfo['uploadDataName']='';      //  refers to where this is stored (self reference, but can be useful)

   miscInfo['upload_auto']='';      //  space delmieted list of textarea or drop or button -- auto upload if one of these occursneces
   miscInfo['echoback_auto']='';      //  space delmieted list of textarea or drop or button -- auto upload if one of these occursneces

   miscInfo['pathPhp']='';              // path to php (that will use wsurvey.uploadFiles.php) --
   miscInfo['pathPhpEchoback']='';              // path to php (that will use wsurvey.uploadFiles.php) --  used for echobacks
   miscInfo['pathPhpEchoback_which']=0;              // path to php (that will use wsurvey.uploadFiles.php) --  used for echobacks

   miscInfo['callback']=false;       // callback after .upload
   miscInfo['callbackClear']=false;       // callback after .upload

   miscInfo['upload_max_filesize']=null;   // limits.
   miscInfo['post_max_size']=null;
   miscInfo['memory_limit']=null;
   miscInfo['maxFiles']=25;

   if (arguments.length>1) {          // read in options ... ignore if not one of the miscInfo fields
      for (var j in optionsArg)  {                             // options in arg override defaultsuse defaults
        if (typeof(miscInfo[j])!=='undefined') miscInfo[j]=optionsArg[j];
      }
   }

// uploadDataName  REQUIRED
    let uploadDataUse=jQuery.trim(uploadDataName);
    if (uploadDataUse=='' || uploadDataUse=='0' || uploadDataUse=='1')  uploadDataUse='wsurvey_uploadFiles_info';
    miscInfo['uploadDataName']=uploadDataUse;

    $(document).data(uploadDataUse,'')  ;   // clear it

    miscInfo['nfiles']=0;    // these always start as empty
    miscInfo['totBytes']=0;
    miscInfo['fileData']=false;   // data(wsurvey_uploadFiles_info) added below

   if (miscInfo['submit']!==false)   {   // submit (call submit.upload()
       let a1=miscInfo['submit'];
       e1=wsurvey.argJquery(a1);

       if (e1===false) {
          alert('wsurvey.uploadFiles.setup: no such submitelement: '+a1);
          return 1;
       }
      miscInfo['submit']=e1;
      e1.attr('wsurvey_uploadFiles_type','submit');           // to help find this
      e1.attr('wsurvey_uploadFiles_name',uploadDataUse);           // to help find this
      e1.data('wsurvey_uploadFiles_uploadData',uploadDataUse);
      e1.on('click',wsurvey.uploadFiles.submit.upload);
   }

   if (miscInfo['echoback']!==false)   {   // echoback  (call submit.echoback()
       let a1=miscInfo['echoback'];
       e1=wsurvey.argJquery(a1);
       if (e1===false) {
          alert('wsurvey.uploadFiles.setup: no such echobackelement: '+a1);
          return 1;
       }
      miscInfo['echoback']=e1;
      e1.attr('wsurvey_uploadFiles_type','echoback');           // to help find this
      e1.attr('wsurvey_uploadFiles_name',uploadDataUse);           // to help find this
      e1.data('wsurvey_uploadFiles_uploadData',uploadDataUse);
      e1.on('click',wsurvey.uploadFiles.submit.echoback);
   }


    if (miscInfo['button']!==false)   {   // button <input type="file"
       let a1=miscInfo['button'];
       e1=wsurvey.argJquery(a1);
       if (e1===false) {
         alert('wsurvey.uploadFiles.setup: no such buttonElement: '+a1);
          return 1;
       }
       if (jQuery.trim(e1.attr('type')).toUpperCase() !=='FILE') {
          alert('wsurvey.uploadFiles.setup error: buttonElement does not have type="file"');
          return 0;
      }
      miscInfo['button']=e1;
      e1.attr('wsurvey_uploadFiles_type','button');           // to help find this
      e1.attr('wsurvey_uploadFiles_name',uploadDataUse);           // to help find this
      e1.data('wsurvey_uploadFiles_uploadData',uploadDataUse);
      e1.on('change',wsurvey.uploadFiles.setFuncs.addFile);
   }

   if (miscInfo['drop']!==false)   {          // dropHandler location
       let a1=miscInfo['drop'];
       let e1=wsurvey.argJquery(a1);
       if (e1===false) {
          alert('wsurvey.uploadFiles.setup: no such dropElement: '+a1);
          return 1;
       }
       miscInfo['drop']=e1;
       e1.attr('wsurvey_uploadFiles_type','drop');           // to help find this
       e1.attr('wsurvey_uploadFiles_name',uploadDataUse);           // to help find this
       e1.data('wsurvey_uploadFiles_uploadData',uploadDataUse);
       e1.on('dragover',wsurvey.uploadFiles.setFuncs.dragOverHandler);
       e1.on('drop',wsurvey.uploadFiles.setFuncs.dropHandler);
   }

      if (miscInfo['textarea']!==false)   {          // textarea savebutton location (or could be the text area, to auto file record
       let a1=miscInfo['textarea'];
       let e1=wsurvey.argJquery(a1);
       if (e1===false) {
          alert('wsurvey.uploadFiles.setup: no such textareaElement: '+a1);
          return 1;
       }
       miscInfo['textarea']=e1;
//find closest textarea to this button.
       let etextareaContent=wsurvey.findRelative(e1,'textarea',1,2);  // must have same grandparent
       if (etextareaContent===false) {
          alert('wsurvey.uploadFiles.setup: can not find textarea (tag) for a textareaElement: '+a1);
          return 1;
       }

       e1.attr('wsurvey_uploadFiles_type','textarea');           // to help find this
       e1.attr('wsurvey_uploadFiles_name',uploadDataUse);           // to help find this
       e1.data('wsurvey_uploadFiles_uploadData',uploadDataUse);
       e1.data('wsurvey_uploadFiles_textareaContent',etextareaContent);
        e1.on('click',wsurvey.uploadFiles.setFuncs.textarea);
   }

   if (miscInfo['clear']!==false)   {    // clear data storage and input elements
       let a1=miscInfo['clear'];
       e1=wsurvey.argJquery(a1);
       if (e1===false) {
          alert('wsurvey.uploadFiles.setup: no such clear element: '+a1);
          return 1;
       }
      miscInfo['clear']=e1;
      e1.attr('wsurvey_uploadFiles_type','clear');           // to help find this
      e1.attr('wsurvey_uploadFiles_name',uploadDataUse);           // to help find this
      e1.data('wsurvey_uploadFiles_uploadData',uploadDataUse);

      e1.on('click',wsurvey.uploadFiles.submit.clear);
   }



   if (miscInfo['summary']!==false)   {            // display summary location
       let a1=miscInfo['summary'];
       let a2= (typeof(a1)=='string' || typeof(a1)=='number') ?   jQuery.trim(a1) : 0 ;
       if (a2=='1')  {         // autocreate ?
              let estore=jQuery('<div class="wsurvey_uploadFiles_summary" >summary of selected files</div>');
              if (miscInfo['button']!==false) {
                   miscInfo['button'].after(estore);
              } else {
                 if (miscInfo['drop']!==false) {
                    miscInfo['drop'].after(estore);
                 } else {
                    if (miscInfo['submit']!==false) {
                        miscInfo['submit'].after(estore);
                    } else {
                       alert('wsurvey.uploadFiles.setup: no place for summary to be placed ');
                       return 1;
                    }
                 }   // drop
              }  // button
              miscInfo['summary']=estore;
              estore.attr('wsurvey_uploadFiles_type','summary');           // to help find this
              estore.attr('wsurvey_uploadFiles_name',uploadDataUse);           // to help find this
              estore.data('wsurvey_uploadFiles_uploadData',uploadDataUse);
        } else  {     // not autocraete
            let e1=wsurvey.argJquery(a1);
            if (e1===false) {
               alert('wsurvey.uploadFiles.setup: no such  summary Element: '+a1);
               return 1;
            }
            miscInfo['summary']=e1;
            e1.attr('wsurvey_uploadFiles_name',uploadDataUse);           // to help find this
            e1.attr('wsurvey_uploadFiles_type','summary');           // to help find this
            e1.data('wsurvey_uploadFiles_uploadData',uploadDataUse);
       }    // autocrate display
   }    // summary

   miscInfo['pathPhp']=jQuery.trim(miscInfo['pathPhp']);

   let pp2=jQuery.trim(miscInfo['pathPhpEchoback']);
   miscInfo['pathPhpEchoback_which']=0;
   if (pp2=='') {
     miscInfo['pathPhpEchoback']=miscInfo['pathPhp'];
   } else {
      let pp2v=pp2.split(/\s+/g) ;
      miscInfo['pathPhpEchoback']=jQuery.trim(pp2v[0]);
      if (pp2v.length>1) miscInfo['pathPhpEchoback_which']=parseInt(pp2v[1]) ;
   }

   let tt1=jQuery.trim(miscInfo['upload_auto'].toLowerCase());
   miscInfo['upload_auto']={};
   if (tt1.indexOf('button')>-1)  miscInfo['upload_auto']['button']=1;
   if (tt1.indexOf('drop')>-1)  miscInfo['upload_auto']['drop']=1;
   if (tt1.indexOf('textarea')>-1)  miscInfo['upload_auto']['textarea']=1;

   let tt1b=jQuery.trim(miscInfo['echoback_auto'].toLowerCase());
   miscInfo['echoback_auto']={};
   if (tt1b.indexOf('button')>-1)  miscInfo['echoback_auto']['button']=1;
   if (tt1b.indexOf('drop')>-1)  miscInfo['echoback_auto']['drop']=1;
   if (tt1b.indexOf('textarea')>-1)  miscInfo['echoback_auto']['textarea']=1;

   if (miscInfo['callback']!==false) {
       let ac=miscInfo['callback'];
       if (typeof(ac)=='string') {
           if (typeof(window[ac])!='function') {
               alert('wsurvey.uploadFiles.setup: no such callback: '+ac);
               return 1;
           }
           miscInfo['callback']=window[ac];
       } else {
           if (typeof(ac)!='function') {
               alert('wsurvey.uploadFiles.setup: no such callback');
               return 1;
           }
       }
   }
   
   if (miscInfo['callbackClear']!==false) {
       let ac=miscInfo['callbackClear'];
       if (typeof(ac)=='string') {
           if (typeof(window[ac])!='function') {
               alert('wsurvey.uploadFiles.setup: no such callbackClear: '+ac);
               return 1;
           }
           miscInfo['callbackClear']=window[ac];
       } else {
           if (typeof(ac)!='function') {
               alert('wsurvey.uploadFiles.setup: no such callbackClear');
               return 1;
           }
       }
   }

//  server side limit info available (as global variables)?
 let mf=miscInfo['maxFiles'] ;
 if (isNaN(mf) || parseInt(mf)<=0) mf=1 ;
 miscInfo['maxFiles']=mf;


 if (miscInfo['post_max_size']!==null) {
     a1=jQuery.trim(miscInfo['post_max_size'])   ;
 } else {           // check for global
     if (typeof(window['wsurvey_uploadFiles_post_max_size'])!=='undefined') {
         a1=window['wsurvey_uploadFiles_post_max_size'] ;
     } else {
        a1=false;        // no limit
     }
 }
 if (a1!==false) {
     if (typeof(a1)=='string') {
        if (a1.slice(-1).toLowerCase()=='m') a1=parseInt(a1)*1000000;
     }
 }
 miscInfo['post_max_size']=a1;

 if (miscInfo['memory_limit']!==null) {
     a1=jQuery.trim(miscInfo['memory_limit'])   ;
 } else {      // check for global
     if (typeof(window['wsurvey_uploadFiles_memory_limit'])!=='undefined') {
         a1=window['wsurvey_uploadFiles_memory_limit'] ;
     } else {
         a1=false;
     }
 }
 if (a1!==false) {
     if (typeof(a1)=='string') {
        if (a1.slice(-1).toLowerCase()=='m') a1=parseInt(a1)*1000000;
     }
 }
 miscInfo['memory_limit']=a1;

 if (miscInfo['upload_max_filesize']!==null) {
     a1=jQuery.trim(miscInfo['upload_max_filesize'])   ;
 } else {      // check for global
     if (typeof(window['wsurvey_uploadFiles_upload_max_filesize'])!=='undefined')  {
        a1=window['wsurvey_uploadFiles_upload_max_filesize'] ;
     } else {
       a1=false ;  // false means "no limit"
     }
 }
 if (a1!==false) {
     if (typeof(a1)=='string') {
        if (a1.slice(-1).toLowerCase()=='m') a1=parseInt(a1)*1000000;
     }
 }
 miscInfo['upload_max_filesize']=a1;

// and this is what is used by .submit, etc

  $(document).data(uploadDataUse,miscInfo);        // miscInfo  contains the queue and other info

  wsurvey.uploadFiles.submit.clear(uploadDataUse,miscInfo['clear']);   // get rid of stuff (ie; that might be leftover from a f5 type of reload )

  return miscInfo  ;                                  // idInfo can be used by clear and unpack

}

//========================
// utility function: get the uploadData, given uploadDataName  -- looks into document.data()
// if aid is a string, use it (or convert 0,1,'' to default);
// if a jquery element, find a uploadData attribute or data() field

wsurvey.uploadFiles.getUploadData=function(uploadDataName,amess) {
  var uploadData;
  if (typeof(uploadDataName)=='string' || typeof(uploadDataName)=='number') {
       uploadData=jQuery.trim(uploadDataName);
       if (uploadData=='' || uploadData=='1' || uploadData=='0') uploadData='wsurvey_uploadFiles_info';  //the default
   } else {
     let eid=wsurvey.argJquery(uploadDataName);
     if (eid===false) {
         alert('wsurvey.uploadFiles. '+amess+': uploadDataName is not an jquery object');
         return false;
     }
     if (typeof(eid.data('wsurvey_uploadFiles_uploadData'))!='undefined') {    // added by .setup
         uploadData= eid.data('wsurvey_uploadFiles_uploadData')  ;
     } else {                                         // perhaps a custom event handler -- can have one of these attirbutes or data() fields
         uploadData=eid.wsurvey_attr(':uploadData,data-uploadData,uploadData','wsurvey_uploadFiles_info',1);
      }
  }
  uploadData= jQuery.trim(uploadData);
  if (typeof($(document).data(uploadData))=='undefined') {
       alert('wsurvey.uploadFiles. '+amess+': '+uploadData+' is not a field of document.data ');
       return false;
  }
  let stuff0=$(document).data(uploadData);
  return stuff0 ;
}


// =-------------------
// the .setFuncs.xx   functions are meant to be used by .setup(). SInce they could be of some use, they are not private
// the .submit.xx functions are used by setup, but may also be called directly


// ==============
// the .submit.xx functions are not used internally used (by .setup(), and can be called direclty
//===========================

//===========================
// upload files that have been "stored"  -- this is  a 'submit' element
// upDateName must point to the element that was the first arg  in a .setup -- such as '1'
// OPts can have several indices, that override options set in .setup()
// if updateName=false, then opts should contain a full specification of the uploadData
// (the object returned by getUploadData)

wsurvey.uploadFiles.submit.upload=function(upDateName,opts,otherInfo) {   // pathPhp,callback,addField) {
  let stuff0;
  if (upDateName!==false) {
    stuff0=wsurvey.uploadFiles.getUploadData(upDateName,'upload') ;
    if (stuff0===false) return 0;
  } else {
     if (arguments.length<2) return 0;
     if (typeof(opts['uploadData'])=='undefined') return 0;
     stuff0=opts['uploadData'];
  }
  var acallback=stuff0['callback'];
  var   pathPhp=stuff0['pathPhp'];
  var addField=false;
  var adelay=0;

  if (arguments.length<3) otherInfo=false;

  if (arguments.length>1)  {        // input element, and callback, and path: attributes of the button that has the clidk event
     if (typeof(opts['pathPhp'])!='undefined' && opts['pathPhp']!==null ) pathPhp=opts['pathPhp'];
     if (typeof(opts['callback'])!='undefined' && opts['callback']!==null ) acallback=opts['callback'];
     if (typeof(opts['addField'])!='undefined' && opts['addField']!==null ) addField=opts['addField'];
     if (typeof(opts['addFields'])!='undefined' && opts['addFields']!==null ) addField=opts['addFields'];   // preferred synoymn
     if (typeof(opts['delay'])!='undefined' && opts['delay']!==null ) adelay=opts['delay'];   // preferred synoymn
     adelay=parseInt(adelay);
     if (adelay<0) adelay=0;
  }

  if (arguments.length>1)   {   // already checked if using setup() specs
    if (acallback!==false) {
      let aa=typeof(acallback);
      if (aa=='string') {
          acallback=jQuery.trim(acallback);
          if (typeof(window[acallback])!='function') {
              console.trace('wsurvey.uploadFiles upload: no such callback: '+acallback);
              return 0;
          }
          acallback=window[acallback];
      } else {
          if (typeof(acallback)!='function') {
              console.trace('wsurvey.uploadFiles upload: no such callback ');
              return 0;
          }
      }
    }
  }      // double check callback

  var nbytes=stuff0['totBytes'];
  var nfiles=stuff0['nfiles'];
  var stuffX=stuff0['fileData'];

  if (stuffX===false || stuffX.length==0)   {
       console.log('No files to be uploaded');
       return 1;
    }
  var stuffV=[];
  for (var m1=0;m1<stuffX.length;m1++) {
     stuffV[m1]=stuffX[m1]['content'];;
  }
  stuff=stuffV.join('\n');

   var adata={'wsurveyUploadFiles_data':stuff,'nfiles':nfiles,'totbytes':nbytes,'wsurvey_uploadFiles_action':'upload'};

  if (addField!==false && typeof(addField)=='object') {
     for  (var dfield in  addField)  {
        let tdfield=jQuery.trim(dfield);
        adata[tdfield]=addField[dfield] ;
     }
 }

  var aj1={'url':pathPhp,'dataType':'text','type':'post','data':adata};        // !!! upload stuff to the server !!!!
  if (adelay>0) {
     window.setTimeout(function() {
       $.ajax(aj1)
       .done(function(data,tstatus,ajx){
           if (acallback===false) {
               console.log('wsurvey.uploadFiles upload response: '+tstatus);
           } else {
               acallback(data,stuff0,tstatus,ajx,otherInfo);
           }
        })
        .fail(function(ajx,astatus,errt){
             alert('error in wsurvey.uploadFiles upload (to: '+pathPhp+'): '+astatus+','+errt);
            return 1;
        }) ;
     },adelay);


  } else {
     $.ajax(aj1)
       .done(function(data,tstatus,ajx){
           if (acallback===false) {
               console.log('wsurvey.uploadFiles upload response: '+tstatus);
           } else {
               acallback(data,stuff0,tstatus,ajx,otherInfo);
           }
        })
        .fail(function(ajx,astatus,errt){
             alert('error in wsurvey.uploadFiles upload (to: '+pathPhp+'): '+astatus+','+errt);
            return 1;
        }) ;
   }
}

//====================
// echo the files back to client (so that it can be downloaded to disk
// if multiple files, echo back as a zip

wsurvey.uploadFiles.submit.echoback=function(aid0,opts) {

  let stuff0=wsurvey.uploadFiles.getUploadData(aid0,'echoback') ;

  if (stuff0===false) return 0;

  let pathPhpEchoback=stuff0['pathPhpEchoback'];
  let which=stuff0['pathPhpEchoback_which'];
  let addField=false;

  if (arguments.length>1)  {        // input element, and callback, and path: attributes of the button that has the clidk event
     if (typeof(opts['pathPhp'])!='undefined' && opts['pathPhp']!==null  ) pathPhpEchoback=opts['pathPhp'];
     if (typeof(opts['pathPhpEchoback'])!='undefined'  && opts['pathPhpEchoback']!==null  ) pathPhpEchoback=opts['pathPhpEchoback']; // preferred synonym
     if (typeof(opts['which'])!='undefined'  && opts['which']!==null ) which=opts['which'];
     if (typeof(opts['addField'])!='undefined' && opts['addField']!==null  ) addField=opts['addField'];   // should be an object with  'name':'value' fields
     if (typeof(opts['addFields'])!='undefined'  && opts['addFields']!==null ) addField=opts['addFields'];   //  preferred synoymn
  }

  var stuffX=stuff0['fileData'];
  if (stuffX===false) {
       console.log('No files to be uploaded');
       return 1;
    }
  var stuffV=[];
  for (var m1=0;m1<stuffX.length;m1++) {
       stuffV[m1]=stuffX[m1]['content'];;
  }
  stuff=stuffV.join('\n');

  let pp='<form action="'+pathPhpEchoback+'" method="post" target="uploadFiles_echoBack" >';
  pp+=' <input type="hidden" name="wsurveyUploadFiles_data" value="'+stuff+'"> ';
  pp+='  <input type="hidden" name="wsurvey_uploadFiles_action" value="echoback">';
  pp+='  <input type="hidden" name="which" value="'+which+'">';
  if (addField!==false && typeof(addField)=='object') {
     for  (var dfield in  addField)  {
        let tdfield=jQuery.trim(dfield);
        pp+='<input type="hidden" name="'+tdfield+'" value="'+encodeURIComponent(addField[dfield])+'" ' ;
     }
  }
  pp+='</form>';
  ff=$(pp);  // temporarily create the form that contains the base64 encoded content of files to upload, submit it, remove it
  $('body').append(ff);
   ff.submit()   ;
   ff.remove();

   return 1;

}

//===========================
// clear list of "files to upload"   -- using info in the upload element

wsurvey.uploadFiles.submit.clear=function(athis,ethis) {
  let stuff=wsurvey.uploadFiles.getUploadData(athis,'clear') ;
  if (stuff===false) return 0;
  if (arguments.length<2) ethis=wsurvey.argJquery(athis);

  var estore=stuff['summary'];   // status area
    if (estore!==false) estore.html('');

  let ebutton=stuff['button'];             // <input type="file" area
    if (ebutton!==false ) ebutton.val('');
  let edrop=stuff['drop'];

    if (edrop!==false ) edrop.html('');        // dropzone  area
  let etextarea=stuff['textarea'];
    if (etextarea!==false )  {
      let etextAreaContent=etextarea.data('wsurvey_uploadFiles_textareaContent');
      etextAreaContent.val('');
    }
  stuff['fileData']=false;                // storage area
  stuff['nfiles']=0;
  stuff['totBytes']=0;
  let uploadDataName=stuff['uploadDataName'];
  $(document).data(uploadDataName,stuff);

  if (ethis!=false) {
    if (stuff['callbackClear']!==false) {
      stuff['callbackClear'](ethis);
    }
  }
  return 1;
}

//=================
// the uploaded in pieces version of upload

wsurvey.uploadFiles.submit.uploadInPieces=function(uploadDataName,opts,otherInfo) {

   if (arguments.length<2) opts={};
   if (arguments.length<3) otherInfo={};

   let astuff=wsurvey.uploadFiles.getUploadData(uploadDataName,'uploadInPieces') ;
   if (astuff===false) return 0;
   let uploadDataNameUse=astuff['uploadDataName'];
   let daFileData=astuff['fileData'] ;
   let nFiles=astuff['nfiles']
   if (nFiles==0) return 0;         //give up
   let totBytes=astuff['totBytes']  ;
   let bcallback=astuff['callback'];

   if (typeof(opts['callback'])=='undefined') opts['callback']=false;

   let origFileData=JSON.parse(JSON.stringify(daFileData)) ;   // clone it

   otherInfo['wsurveyUploadFiles_origInfo']=[origFileData,nFiles,totBytes,bcallback];      // this is pulled from one row at a time

   let tdelay=typeof(opts['delay']);
   if (tdelay=='undefined' || opts['delay']===false ||isNaN( opts['delay'])) opts['delay']=100 ;  // 0.1 seconds
   otherInfo['wsurveyUploadFiles_origOpts']=opts;

   otherInfo['wsurveyUploadFiles_nextDo']=0;
   otherInfo['wsurveyUploadFiles_justdone']=false;
   otherInfo['wsurveyUploadFiles_nTodo']=nFiles ;
   otherInfo['wsurveyUploadFiles_callbackPieces']= opts['callback'] ;
   let idZ2=uploadDataNameUse+'$control';
   otherInfo['wsurveyUploadFiles_control']= idZ2 ;
   $(document).data(idZ2,false);

   wsurvey.uploadFiles.submit.uploadInPieces2(astuff,opts,otherInfo) ;
}

// this does the work,   iteratively
wsurvey.uploadFiles.submit.uploadInPieces2=function(astuff,opts,otherInfo) {

   let origInfo=otherInfo['wsurveyUploadFiles_origInfo'];   // this is added by wsurvey.uploadFiles.uploadInPieces(
   let daFileData=origInfo[0];
   nextDo=otherInfo['wsurveyUploadFiles_nextDo'] ;
   whichone=daFileData[nextDo];
   totBytes=whichone['totBytes'] ;
   astuff['totBytes']=totBytes;     // a hack to get upload() to work propery
   astuff['nfiles']=1;
   astuff['fileData']=[whichone];

   opts['callback']=wsurvey.uploadFiles.submit.uploadInPieces3;
   opts['uploadData']=astuff;                // delay, and addfields, used as is

   wsurvey.uploadFiles.submit.upload(false,opts,otherInfo);    // upload just  one file
   return 1;
}

// the call back from .upload() ... as specified in uploadInPieces2
// report status, and possibly iterate bck to uploadInPieces2
wsurvey.uploadFiles.submit.uploadInPieces3=function(response,stuff,tstatus,xhr,otherInfo) {

   let origInfo=otherInfo['wsurveyUploadFiles_origInfo'];   // these are added by wsurvey.uploadFiles.uploadInPieces(
   let daFileData=origInfo[0];
   let nTodo=otherInfo['wsurveyUploadFiles_nTodo'] ;      // 2:orig totbyes, 3: orig callback
   let justDone=otherInfo['wsurveyUploadFiles_nextDo'] ;
   let origOpts=otherInfo['wsurveyUploadFiles_origOpts'];
   let ocallback=otherInfo['wsurveyUploadFiles_callbackPieces'];   // the callback for one at a time results
   let controlVarName= otherInfo['wsurveyUploadFiles_control']  ;

   otherInfo['wsurveyUploadFiles_justdone']=justDone;

    if (ocallback!==false) ocallback(response,stuff,tstatus,xhr,otherInfo);

   if (justDone< (nTodo-1) )  {   // more to do
      let controlVar=$(document).data(controlVarName);

      if (controlVar===false  ) {
        let adelay=origOpts['delay'];
        if (isNaN(adelay) || adelay<0) adelay=100;
        otherInfo['wsurveyUploadFiles_nextDo']=justDone+1 ;
        window.setTimeout(function() {
           wsurvey.uploadFiles.submit.uploadInPieces2(stuff,origOpts,otherInfo);
        },adelay);
        return 1;
      }  // controlVar false
      if (controlVar[0]==='pause'  ) return 1;     // pause: don't do anything, but don't reset

   }
// either done, or controlVar='stop'
//  reset the original upladData info
   stuff['fileData']=daFileData;
   stuff['nfiles']=nTodo;
   stuff['totBytes']=origInfo[2];
   stuff['callback']=origInfo[3];
   let uploadDataName=stuff['uploadDataName'];
   $(document).data(uploadDataName,stuff);

}
// ------
// set a control var. or resume
wsurvey.uploadFiles.submit.uploadInPieces_control=function(action,stuff,otherInfo) {
  var controlVarName;

   if (action=='stop') {   // stop procesing
      controlVarName= otherInfo['wsurveyUploadFiles_control']  ;
      $(document).data(controlVarName,['stop',false]);  //actions3 will see this and stop -- reset parameters
      return 1;
   }
   if (action=='pause') {   // stop procesing
       controlVarName= otherInfo['wsurveyUploadFiles_control']  ;
      let tmp=[stuff,otherInfo];
      $(document).data(controlVarName,['pause',tmp]);  //actions3 will see this and stop  -- return with no other action
      return 1;
   }

 // else, a resume
  let zstuff=wsurvey.uploadFiles.getUploadData(stuff,'uploadInPieces_control') ; // have to use global stuff on a resume
  controlVarName=zstuff['uploadDataName']+'$control';
  let tmp0=  $(document).data(controlVarName);
  let tmp=tmp0[1];
  let stuff2=tmp[0],otherInfo2=tmp[1];
  let opts2=otherInfo2['wsurveyUploadFiles_origOpts'];
  let jdone=otherInfo2['wsurveyUploadFiles_justdone'];
  otherInfo2['wsurveyUploadFiles_nextDo']=jdone+1 ;
  $(document).data(controlVarName,false);   // remove control instructions
   wsurvey.uploadFiles.submit.uploadInPieces2(stuff2,opts2,otherInfo2) ;

   return 1;
}

// ==============
// the .setFuncs.xx functions are   meant for internal used  -- they are used by  .setup()
//===========================

// onchange handler for type="file" element (that was initialized using setup
wsurvey.uploadFiles.setFuncs.addFile=function(evt) {

  let targ=evt.target ;   // contains the files object created when files were selected by user (possibly via drag and drop)

  let adata=wsurvey.uploadFiles.getUploadData(evt,'addFile') ;
  if (adata===false) return 0;

  let uploadDataName=adata['uploadDataName'];
  let  upload_max_filesize=adata.upload_max_filesize;  // non changables set by .setup()
  let  memory_limit=adata.memory_limit;
  let  post_max_size=adata.post_max_size;
  let maxFiles=adata.maxFiles ;

// what's already in the queue   -- added to as client selects more files
  var  wasFiles=parseInt(adata['nfiles']);
  var  totBytes=parseInt(adata['totBytes']);

  let files=targ.files;    // files is a FileList of File objects.

 // get summary info, and check some limits
  let goo=wsurvey.uploadFiles.setFuncs.addFile_summary(files,upload_max_filesize,maxFiles-wasFiles,uploadDataName) ;  //   return [output,usethese,totBytes] ;

  let output =goo[0];
  let usethese=goo[1];
  let itodo=usethese.length ;

  totBytes=totBytes+goo[2];   // pre procsssing bytes (does NOT account for encoding)

// check on server limits
  if (( memory_limit!==false && totBytes>memory_limit) || (post_max_size!==false && totBytes>post_max_size) ){
     let amess='Warning: after adding these files, the total size of files to be uploaded ('+wsurvey.addComma(totBytes)+') exceeds one of the server limits: \n';
     amess=amess+'\t post_max_size: '+wsurvey.addComma(post_max_size)+' \n ';
     amess=amess+'\t memory_limit: '+wsurvey.addComma(memory_limit)+' \n ';
     amess=amess+'Are you sure you want to add these additional files? ';
     let yy=confirm(amess);
     if (!yy) {
        alert('The selected files will not be uploaded ');
        return 1;
     }
  }

 // if here, will be uploaded. Assume success (could do this after addFile_data...)
  let eDisplay=adata['summary'];  // where to write summary info
  if(eDisplay!==false) {
    eDisplay.append('<ul style="margin-left:2px;padding:2px;list-style-type:none;border:1px dashed tan;" title="From input button">' + output.join('') + '</ul>');   // display summary of chosen files
    let jfoo=wasFiles+itodo;
    wsurvey.uploadFiles.setFuncs.summaryHeader(eDisplay,jfoo,totBytes);
  }

// addFile_data will process and write results to eUpload
  wsurvey.uploadFiles.setFuncs.addFile_data(usethese,adata,'inputButton') ;   // adata includes info  on files that have been selected

// give time for files to be read from disk...
  window.setTimeout(function() {
    if (typeof(adata['upload_auto']['button'])!='undefined') {
       wsurvey.uploadFiles.submit.upload(uploadDataName);
   } else {
      if (typeof(adata['echoback_auto']['button'])!='undefined') {
         wsurvey.uploadFiles.submit.echoback(uploadDataName);
      }
   }
  },1000);

  return 1;
}


//=====================
// on drop handler for dropzone file upload
wsurvey.uploadFiles.setFuncs.dropHandler=function(ev) {

  let adata=wsurvey.uploadFiles.getUploadData(ev,'dropHandler') ;
  if (adata===false) return 0;
  let uploadDataName=adata['uploadDataName'];

 var evUse=ev ;
 if (!ev.hasOwnProperty('dataTransfer')) {
    if (typeof(ev['originalEvent'])=='undefined') {
        alert('wsurvey.uploadFiles dropHandler: no dataTransfer method ');
        return 0 ;
    }
    var ev2=ev['originalEvent'] ;
    if (typeof(ev2['dataTransfer'])=='undefined') {
        alert('wsurvey.uploadFiles dropHandler: no dataTransfer method in origEvent');
        return 0;
    }
    evUse=ev2;
 }

 let  upload_max_filesize=adata.upload_max_filesize;  // non changables set by .setup()
 let  memory_limit=adata.memory_limit;
 let  post_max_size=adata.post_max_size;
 let maxFiles=adata.maxFiles ;

// what's already in the queue   -- added to as client selects more files
 var  wasFiles=parseInt(adata['nfiles']);
 var  totBytes=parseInt(adata['totBytes']);

 evUse.preventDefault();          // event handlers stops here
 let files=evUse.dataTransfer.files ;

  // get summary info, and check some limits
 let goo=wsurvey.uploadFiles.setFuncs.addFile_summary(files,upload_max_filesize,maxFiles-wasFiles,uploadDataName) ;  //   return [output,usethese,totBytes] ;

 let output =goo[0];
 let usethese=goo[1];
 let itodo=usethese.length ;

 totBytes=totBytes+goo[2];   // pre procsssing bytes (does NOT account for encoding)
// check on server limits
 if (( memory_limit!==false && totBytes>memory_limit) || (post_max_size!==false && totBytes>post_max_size) ){
     let amess='Warning: after adding these files, the total size of files to be uploaded ('+wsurvey.addComma(totBytes)+') exceeds one of the server limits: \n';
     amess=amess+'\t post_max_size: '+wsurvey.addComma(post_max_size)+' \n ';
     amess=amess+'\t memory_limit: '+wsurvey.addComma(memory_limit)+' \n ';
     amess=amess+'Are you sure you want to add these additional files? ';
     let yy=confirm(amess);
     if (!yy) {
        alert('The selected files will not be uploaded ');
        return 1;
     }
 }

 // if here, will be uploaded. Assume success (could do this after addFile_data...)

 let eDisplay=adata['summary'];  // where to write summary info
 if(eDisplay!==false) {
    eDisplay.append('<ul style="margin-left:2px;padding:2px;list-style-type:none;border:1px dashed brown;"  title="From drop zone">' + output.join('') + '</ul>');
    let jfoo=wasFiles+itodo;
    wsurvey.uploadFiles.setFuncs.summaryHeader(eDisplay,jfoo,totBytes) ;
 }

 let euse=wsurvey.argJquery(ev);
 euse.html('<tt>'+usethese.length+' files selected ');

 wsurvey.uploadFiles.setFuncs.addFile_data(usethese,adata,'dropZone') ;

// give time for files to be read from disk...
  window.setTimeout(function() {
    if (typeof(adata['upload_auto']['drop'])!='undefined') {
      wsurvey.uploadFiles.submit.upload(uploadDataName);
   } else {
      if (typeof(adata['echoback_auto']['drop'])!='undefined') {
        wsurvey.uploadFiles.submit.echoback(uploadDataName);
      }
   }
 },1000);


}   // drophandler

// drag handler (supporess dragging other elements while moving files into dropzome)
wsurvey.uploadFiles.setFuncs.dragOverHandler=function(ev) {
//  console.log('File(s) in drop zone');
  ev.preventDefault();
}

//=========================
// helper function used by addFile and dropHandler
// create array of "strings" suitable for transomission to wsurvey.updateFiles.php
// usethese is array of file objects to extract data from  -- using fileReader
// feb 2022: it is rumored that using arrayBuffer is better, but I haven't the time to suss out how to convert arrayBuffer to string :(
//  usethese is array with file (and other) information supplied by the browser after files have been selected (or dropped)
// adata is prior contents of this uploadData

wsurvey.uploadFiles.setFuncs.addFile_data=function(usethese,adata,comment) {

// this stores results to the  document.data  ... it does this after all files have been proecssed
// by the (reader) callback

 var cache=[];
 var itodo=usethese.length;
 for (var m=1;m<itodo;m++) cache[m]=false;  // false signifies "not yet read" (or error)
 var totBytesF=0;
 for (var i=0;i<itodo;i++) {
   let reader = new FileReader();
   let afile1x=usethese[i];
   let aidx=afile1x['id'];
   let afile1=afile1x['content'];
   reader.readAsDataURL(afile1);                  // dataUrl returns  base64 encoded results!

//  after file is retrieved this is called. Note buildup of the cache variable... save all resunts when cache is fully populated
// afileUse is the file object, from which date, etc info is pulled
// evt2 is the "read content" from readAsDataUrl --  it contains the actual file contents (if many files, read asynchronously)

   jQuery(reader).on('load',{'idx':aidx,'itodo':itodo,'ith':i,'afileUse':afile1},function(evt2) {
       let i1=evt2.data.ith;
       let afileX=evt2.data.afileUse ;
       let aidx=evt2.data.idx;
       let itodo=evt2.data.itodo ;

       let ddate=afileX.lastModified  ;
       let ddate2=new Date(ddate);
       let ddate3=ddate2.toLocaleDateString()+' '+ddate2.toLocaleTimeString();  // may not be standard, but sufficient for wsurvey.uploadFiles

//  feb 2022: lastModifiedDate   is not always present in browser supplied info: lastModifiedDate format is rumored to be: Fri Apr 24 2015 17:27:40 GMT-0400 (Eastern Standard Time) (most browsers don't include this field)

       let targ2 = evt2.target;
       let acontent= targ2.result;     // since readAsDataUrl is used, result will already be base64 encoded

// Note that acontent includes a 'data:mimetype;base64,' as a prefix,
       totBytesF+=afileX.size;
       let stuff=[encodeURIComponent(afileX.name),encodeURIComponent(afileX.type),encodeURIComponent(afileX.size),encodeURIComponent(ddate3),acontent,0,encodeURIComponent(comment)].join(',');
       let ws3=wsurvey.crc32(stuff);
       let wstuff=ws3+','+stuff;
       cache[i1]={'id':aidx,'content':wstuff,'fileLen':afileX.size,'fileName':afileX.name,'comment':comment};

// now check to see if all files have been retrieved and saved to cache
       let inot=0;
       for (var m=0;m<itodo;m++) {
          if (cache[m]===false) inot++;
       }
       if (inot!=0) return 1;             // one  or move of the file reads still in process

// if here, no more fileto be done!

// size check could go here

       let oldStuff=adata['fileData']  ;   // prior files selected
       if (oldStuff!==false) jQuery.merge(cache,oldStuff);

       adata['fileData']=cache ;            // and store cumulative "list of files"
       adata['nfiles']+=itodo ;
       adata['totBytes']+=totBytesF  ;  // actual length (post processing)
       let useName=adata['uploadDataName'];
       $(document).data(useName,adata);

     });  // jquery reader load

    jQuery(reader).on('error',function(evt2) {                 // on error this is called
       var targ2 = evt2.target;
       var goo='' ;
       for (var a in targ2.error) goo=goo+''+a+'='+targ2.error[a]+'\n';
       let zmess="File "+afile.name+" could not be read! Code " +goo ;
       console.log(zmess);
       alert(zmess);
    })   // error
  }         // for  files
  return 1;
}


//------------
// helper function used by addFile and dropHandler
// Creates a summary of the files just selected (using addFile or dropHandlero)
// and check for constraints
//  returns summary, list  (of file objects) of files to be processed, totBytes in these files
//  maxFilesNow: number of allowed
//  upload_max_filesize : max size (in bytes) of any one file (pre encoding)

wsurvey.uploadFiles.setFuncs.addFile_summary=function(files,upload_max_filesize,maxFilesNow,uploadDataName) {

  var igot=0;
  var totBytes=0;
  var  output=[]  ;   // will contain summary info on each of the files
  var usethese=[];   // files (each element a file object) that will be uploaded (that don't violate a limit)

  for (var i=0;i<files.length;i++) {
    let f=files[i];
    if ( igot>=maxFilesNow)  {
       output.push('<li>Sorry, you selected more than '+maxFilesNow+' files; '+f.name+' will not be uploaded</li>')
       continue ;
    }
    if (upload_max_filesize!==false && f.size>=upload_max_filesize) {
       output.push('<li>Sorry, '+f.name+' is '+f.size+' bytes, which is greater than the maximum of '+upload_max_filesize+ '; so it will not be uploaded </li>')
    } else {
      igot++;
      let idX=Math.random().toString(36).substring(2, 15) ;
      usethese.push({'id':idX,'content':files[i]});
      let ddate=(f.lastModified) ;
      let ddate2=new Date(ddate);
      let ddate3=ddate2.toLocaleDateString()+' '+ddate2.toLocaleTimeString();
      totBytes=totBytes+parseInt(f.size);
      let adel='<input type="button" style="font-size:80%;margin:1px;padding:1px" onClick="wsurvey.uploadFiles.setFuncs.remove1(this)" ';
      adel+=' value="&#11199;" title="remove this file from upload list" data-rowid="'+idX+'" data-uploaddataname="'+uploadDataName+'">';
      let aline='<li>'+adel+'<b>'+encodeURI(f.name)+'</b> ('+ (f.type||'n/a')+')';
      aline+= f.size+' bytes , lastMod='+ddate3+'</li>';
      output.push(aline);
     }
  }
  return [output,usethese,totBytes] ;
}


//=======================
// on click handler for save-textarea (using the nearest textarea)
wsurvey.uploadFiles.setFuncs.textarea=function(athis ) {
  let adata=wsurvey.uploadFiles.getUploadData(athis,'textArea') ;
  if (adata===false) return 0;
  let e1=wsurvey.argJquery(athis);
  let etextareaContent= e1.data('wsurvey_uploadFiles_textareaContent');
  let aval=etextareaContent.val();
  wsurvey.uploadFiles.textUpload(athis,aval,'text/plain','','textarea');  // use random name
}


//==================
// remove an entry from the fileData
wsurvey.uploadFiles.setFuncs.remove1=function(athis) {
    let ethis=wsurvey.argJquery(athis);
    let aid=ethis.attr('data-rowid');
    let uploadDataName=ethis.attr('data-uploaddataname');

    let stuff=$(document).data(uploadDataName);
    let fileData=stuff['fileData'];
    let fileDataNew=[];
    doRemove=false;
    for (var mm=0;mm<fileData.length;mm++) {
       afd=fileData[mm];
       aidx=afd['id'];
       if (aidx==aid) {
          doRemove=mm;
          break;
       }
    }
    if (doRemove===false) return 0;  // no match found

    let LL=fileData[doRemove]['fileLen'] ;

    fileData.splice(doRemove,1);
    stuff['fileData']=fileData;
    let nstuff=stuff['nfiles']-1;
    stuff['nfiles']=nstuff;
    stuff=$(document).data(uploadDataName,stuff);

    let eli=ethis.closest('li');
    let etop=ethis.closest('.infoDisplay');
    let egoo=etop.find('.wsurvey_totFilesToUpLoad');

    let egoo2=egoo.find('.wsurvey_totFilesToUpLoadA');

    egoo2.html(nstuff);
    let egoo3=egoo.find('.wsurvey_totFilesToUpLoadB');
    let blen=egoo3.attr('data-size');
    let blenNew=parseInt(blen)-LL ;
    egoo3.html(wsurvey.addComma(blenNew));
    egoo3.attr('data-size',blenNew);

    eli.remove();

}


//==============
// update header in 'summary'

wsurvey.uploadFiles.setFuncs.summaryHeader=function(eDisplay,jfoo,totBytes) {
    let egoo=eDisplay.find('.wsurvey_totFilesToUpLoad');
    if (egoo.length==0) {
        let sayfiles='<span class="wsurvey_totFilesToUpLoadA">'+jfoo+'</span>';
        let saybytes=wsurvey.addComma(totBytes);
        let sayBytes2='<span class="wsurvey_totFilesToUpLoadB" data-size="'+totBytes+'" title="Actual bytes transferred will be greater (after url encoding, etc)">'+saybytes+'</span> ';
        let asay=sayfiles+' / '+sayBytes2;
        let g1='<div style="font-size:80%;margin:3px 5px 2px 5px">files/bytes to upload:';
        g1+='     <span class="wsurvey_totFilesToUpLoad">'+asay+'</span></div>' ;
        eDisplay.prepend(g1);
    } else {
        let e1=egoo.find('.wsurvey_totFilesToUpLoadA');
        e1.html(jfoo);
        let e2=egoo.find('.wsurvey_totFilesToUpLoadB');
        e2.html(wsurvey.addComma(totBytes));
        e2.attr('data-size',totBytes);
    }
    return 1;
}


/// ::::::::::::::::: end of .setFuncs. and .submit. functions


//================================
//  additional "public" functions
//  These work with data, etc created by .setup()
//==============================

//===========================
// add an explicit string (as it was a file)
// Often from a textarea, but could be from anywgere
// does NOT have to be text (could be an impge)
// athis: string or jquery/dom object: the input type="file" button -- where uploadFiles queue is stored
// astring: string to "upload as file"
// atype: mimeType. If not specified, text/plain is used
// aname:  name of file. If not specified, random name generated (ending in .txt)

wsurvey.uploadFiles.textUpload=function(athis,astring,atype,aname,comment) {
  if (arguments.length<2) {
      alert('wsurvey.upload.textUpload error: no 2nd (string) argument');
      return 0;
  }
  let adata=wsurvey.uploadFiles.getUploadData(athis,'textUpload') ;
  if (adata===false) return 0;
  let uploadDataName=adata['uploadDataName'];

  if (arguments.length<3 || jQuery.trim(atype)=='')  atype='application/octet-stream';

  let date1=Date.now();
  let ddate2=new Date() ;   // current date
  let ddate3=ddate2.toLocaleDateString()+' '+ddate2.toLocaleTimeString();

  if (arguments.length<4 || jQuery.trim(aname)=='' ) aname='uploadFile_'+date1+'.txt';

  if (arguments.length<5) comment='other';

 let targ=athis.target ;

 let  upload_max_filesize=adata.upload_max_filesize;
 let  memory_limit=adata.memory_limit;
 let  post_max_size=adata.post_max_size;
 let maxFiles=adata.maxFiles ;

 let estore=adata['summary'];

 var lenString=astring.length;
 let aidX=Math.random().toString(36).substring(2, 15) ;

 var  wasFiles=parseInt(adata['nfiles']);
 var  totBytes=parseInt(adata['totBytes']);
 var oldStuff=adata['fileData']

 let output = [];
 var itodo=1 ;
 cache=[];

 var igot=wasFiles;

 if (maxFiles !==0 && igot>=maxFiles)  {
       output.push('<li>Sorry, you selected more than '+maxFiles+' files;  your string will not be uploaded</li>')
       if (estore!==false) estore.append('<ul>' + output.join('') + '</ul>');   // display info on chosen files
       return 1;
 }
 if (upload_max_filesize!==false && lenString>=upload_max_filesize) {
       output.push('<li>Sorry your string is '+ lenString+' bytes, which is greater than the maximum of '+upload_max_filesize+ '; so it will not be uploaded </li>')
       if (estore!==false) estore.append('<ul>' + output.join('') + '</ul>');   // display info on chosen files
       return 1;
  } else {
      igot++;
      totBytes=totBytes+lenString;

      let adel='<input type="button" style="font-size:80%;margin:1px;padding:1px" onClick="wsurvey.uploadFiles.setFuncs.remove1(this)" ';
      adel+=' value="&#11199;" title="remove this file from upload list"  data-rowid="'+aidX+'" data-uploaddataname="'+uploadDataName+'" >';

      let aline='<li>'+adel+'<b> '+aname+'</b> ('+ atype+')';
      aline+= lenString+' bytes , lastMod='+ddate3+'</li>';
      output.push(aline);
 }

// check on server limits
 if (   ( memory_limit!==false && totBytes>memory_limit) || (post_max_size!==false && totBytes>post_max_size) ){
     let amess='Warning: after adding these files, the total size of files to be uploaded ('+wsurvey.addComma(totBytes)+') exceeds one of the server limits: \n';
     amess=amess+'\t upload_max_filesize: '+wsurvey.addComma(upload_max_filesize)+' \n ';
     amess=amess+'\t post_max_size: '+wsurvey.addComma(post_max_size)+' \n ';
     amess=amess+'\t memory_limit: '+wsurvey.addComma(memory_limit)+' \n ';
     amess=amess+'Are you sure you want to add more files? ';
     let yy=confirm(amess);
     if (!yy) {
        alert('The selected files will not be uploaded ');
        return 1;
     }
 }

 if(estore!==false) {
    let acomment=jQuery.trim(comment).substr(0,20);
    estore.append('<ul style="margin-left:2px;padding:2px;list-style-type:none;border:1px dashed lime;"  title="From '+acomment+'">' + output.join('') + '</ul>');   // display info on chosen files
    let jfoo=wasFiles+itodo;
    wsurvey.uploadFiles.setFuncs.summaryHeader(estore,jfoo,totBytes) ;
 }

//    alert('astrtin '+astring);
 let content64,didEncode=0;
 try {
    content64=btoa((astring));
 } catch(error) {     // problem -- encode first
     content64=btoa(encodeURIComponent(astring));
     didEncode=1;
 }

 /// note addtion of "data:" index (not needed to be specified when fileread)
  let stuff=[encodeURIComponent(aname),encodeURIComponent(atype),encodeURIComponent(lenString),encodeURIComponent(ddate3),'data:'+atype+';base64',content64,didEncode,encodeURIComponent(comment)].join(',');
  let ws3=wsurvey.crc32(stuff);
  let wstuff=ws3+','+stuff;

  cache=[];
  cache[0]={'id':aidX,'content':wstuff,'fileLen':lenString,'fileName':aname,'comment':comment}

   if (oldStuff!==false)  {
     jQuery.merge(cache,oldStuff );
  }
  adata['fileData']=cache ;            // and store cumulative "list of files" in the input element that php should parse for file contents, etc
  adata['nfiles']=wasFiles+itodo ;
  adata['totBytes']=totBytes ;

  $(document).data(uploadDataName,adata);

// give time for files to be read from disk... then auto upload/echoback?
  window.setTimeout(function() {
     if (typeof(adata['upload_auto'][comment])!='undefined') {
        wsurvey.uploadFiles.submit.upload(uploadDataName);
     } else {
        if (typeof(adata['echoback_auto'][comment])!='undefined') {
           wsurvey.uploadFiles.submit.echoback(uploadDataName);
        }
     }
  },1000);

  return cache ;
}


//=-===========================
// retrieve fileInfo, etc stored in a uploadData field (of document.data()
wsurvey.uploadFiles.uploadDataField=function(adata,afield) {

  if (adata===false) return false ;

  if (arguments.length<2)  return typeof(adata);

  if (afield=='*') {
      let goo={};
      for (var hh in adata) {
         let htype=typeof(adata[hh]);
         let alen= '' ;
         if (htype=='string'){
              alen=' '+adata[hh].length+' bytes';
              if (adata[hh].length<60) alen+=' == '+wsurvey.htmlspecialchars(adata[hh]);
         }
         if (htype=='boolean') {
             alen = (adata[hh]) ? ' true ' : ' false ' ;
         }
         if (htype=='object') {
              alen= (adata[hh] instanceof jQuery) ? ' jQuery ' : '  ';
         }
         if (htype=='number') alen= adata[hh] ;
         goo[hh]=htype+' '+alen ;
      }
      return goo;
  }
  if (typeof (adata[afield])!='undefined') return adata[afield];
  return false ;
}

//==================
// change the fileData (uploaded stuf) field
wsurvey.uploadFiles.updateFileData=function(aid,adata ) {
  let wasdata=wsurvey.uploadFiles.getUploadData(aid,'updateFileData') ;
  let uploadDataName=wasdata['uploadDataName'];

  let totsize=0;
  for (var i1=0;i1<adata.length;i1++) totsize+=parseInt(adata[i1]['fileLen']);

  wasdata['fileData']=adata;
  wasdata['totBytes']=totsize;
  wasdata['nfiles']=adata.length;

  $(document).data(uploadDataName,wasdata);

   let totBytes=0;
   let xoutput=[];
    return 1;
}
//================
// create a summary of each file in a lsit of files to uplaod
wsurvey.uploadFiles.updateSummary=function(uploadDataName, aFileList) {

  let stuff0=wsurvey.uploadFiles.getUploadData(uploadDataName,'updateFileData') ;
  uploadDataName=stuff0['uploadDataName'] ;
  let eDisplay=stuff0['summary'];  // where to write summary info
  if (eDisplay===false) return 0 ; // no display
  var totBytes=0;
  xoutput=[];


  for (var jj=0;jj<aFileList.length;jj++)  {
    let afile=aFileList[jj];
    totBytes+=parseInt(afile['fileSize']);

    let atype=afile['fileType'], aname=afile['fileName'],idX=afile['rowId'];
    let asize=afile['fileSize'],adata=afile['fileDate'];

    let adel='<input type="button" style="font-size:80%;margin:1px;padding:1px" ';
    adel+='    onClick="wsurvey.uploadFiles.setFuncs.remove1(this)" ';
    adel+='    value="&#11199;" title="remove this file from upload list" data-rowid="'+idX+'" ';
    adel+='     data-uploaddataname="'+uploadDataName+'">';
    aline='<li title="Comment: '+wsurvey.htmlspecialchars(afile['comment'])+'">'+adel;
    aline+='<b>'+encodeURI(aname)+'</b> ('+ (atype||'n/a')+')';
    aline+= asize+' bytes , lastMod='+adata+'</li>';
    xoutput.push(aline);
  }
  eDisplay.html('<ul style="margin-left:2px;padding:2px;list-style-type:none;border:1px dashed tan;" title="After remove and modify">' + xoutput.join('') + '</ul>');
  wsurvey.uploadFiles.setFuncs.summaryHeader(eDisplay,aFileList.length,totBytes);
}


///=======================
// utility function to unpack stuff uploadData object
// Typically, retrieve this object using .getUploadData().
// if you are just going to submit uploaded information to a php script, you dont need to use  this
//       'fileContent' : content of the file
//       'filename' : filename
//       'fileType'    : guess of mime type
//       'fileDate'  : modification date   (Fri Apr 24 2015 17:27:40 GMT-0400 (Eastern Standard Time))
//       'fileSize' : determined from length of fileContent
// dastuff can be retrieved using somethinkg like dastuff=wsurvey.uploadFiles.getUploadData(1)

wsurvey.uploadFiles.unpackFileData=function(dastuff) {

 if (typeof(dastuff)!='object') {              // might be what setup returend.
       alert('wsurvey.uploadFiles.unpackFileData error: argument not an object ');
       return 0;
   }
 var nfiles=dastuff['nfiles'];
 var fileData=dastuff['fileData'];
 var totBytes=dastuff['totBytes'];
 var stuff=[];
 if (nfiles==0 || fileData=='') return stuff ; // empty

 for (var i=0;i<fileData.length;i++) {

     let af1=fileData[i];
     let aidx=af1['id'];
     let aline=af1['content'];
     let aa=aline.split(',');
     let crc32=aa[0];
     let fname=decodeURIComponent(aa[1]);
     let filetype=decodeURIComponent(aa[2]);
     let filesize=decodeURIComponent(aa[3]);
     let fileMod =decodeURIComponent(aa[4]);  // [5] is base64;mime-type, that is provided by reader.readdatasur.
     let b64=decodeURIComponent(aa[5]);
     let isUriEncode=aa[7] ;
     let fileContent;
     if (isUriEncode==1) {
          fileContent= decodeURIComponent(atob(aa[6]));
     } else {
          fileContent= atob(aa[6]);
     }
     let acomment=decodeURIComponent(aa[8]);
     let aa1={'rowId':aidx,'crc32':crc32,'fileName':fname,'fileType':filetype,'fileSize':filesize,
              'fileDate':fileMod,'fileContent':fileContent,'comment':acomment,'b64':b64};
     stuff.push(aa1);
 }

 return stuff ;
}

//==========
// create uploadable "fileData" from "unpacked, possibly changed"  status
wsurvey.uploadFiles.packFileData=function(dastuff) {

 var new1=[];
  for (var i=0;i<dastuff.length;i++) {

     let af1=dastuff[i];

     let content64,astring=af1['fileContent'];
     try {
      content64=btoa(astring) ;
      didEncode=0;
   } catch(error) {     // problem -- encode first
       content64=btoa(encodeURIComponent(astring));
       didEncode=1;
   }
   let fname=af1['fileName'];
   let rowid=af1['rowId'];
   let fsize=af1['fileSize'];
   let acomment=af1['comment'];
   let stuff=[encodeURIComponent(fname),encodeURIComponent(af1['fileType']),
            encodeURIComponent(fsize),encodeURIComponent(af1['fileDate']),
            af1['b64'],
            content64,didEncode,encodeURIComponent(acomment)].join(',');
    let ws3=wsurvey.crc32(stuff);
    let wstuff=ws3+','+stuff;

    new1[i]={'id':rowid,'content':wstuff,
                  'fileLen':fsize,'fileName':fname,'comment':acomment};
 }

 return new1;
}


