//========
//  Functions to resize "rows" and "columns" of blocks. Requires jquery
//  See wsurveyResizer.txt for details
//
// This enables bars that can be dragged to resize "blocks" adjacent to the bar (either to left and right, or above and below)
//
// Arguments: where the first three are required:
//  blocka: string containing id of one (or more, in space delimited list) blocks (typically <divs>) that will be resized. This is either the "left" or "top"
//  blockb: string containing id of one (or more, in space delimited list) blocks (typically <divs>) that will be resized. This is either the "right" or "bottom"
//  mover : string containing id of one (just one!) block (<div> or <span> that when clicked and moved will resize blocka and blockb.
//  dire : H for "horizontal resizing" (left and right adjacency), V for "vertical resizing" (top and bottom adjacency). Default is V
//  minsize : minimum size after resizing. Default is 50.
// dormb :  do auto-resizing if mover bar is clicked. If not specified, or 0, rmb not enabled.
//           If a 1 (the default), an rmb on a mover bar will toggle left (or top) bar between   95%, and 60% 
//            of size (height or width) of parent container
//           Or specify  two or more percents witn a n (n>1) element array of integers between 5 and 95. i.e.  [ 80,50]
//           Sizes do NOT have to be ascending or descending --   rmb'ing will cycle through these sizes
//
// Examples:
//          wsurvey.resizer.init('mainBlock_1a  mainBlock_1b','mainBlock_2','mainBlock_rowSep','V',50,1);    // note that  two ids are specified in blockA
//          wsurvey.resizer.init('mainBlock_1a','mainBlock_1b','mainBlock_colSep','H',50,[40,70]);
//          wsurvey.resizer.init('mainBlock_1a','mainBlock_1b','mainBlock_colSep','H',50,[70,90,10,30,50]);

// intialize the wsurvey. "namespace" if not already initialized by some other wsurvey.xxx.js
if (typeof(wsurvey)=='undefined')  {
    var wsurvey={};
}
if (typeof(wsurvey['resizer'])=='undefined')  {
      wsurvey['resizer']={};
}


wsurvey.resizer.init=function(blocka,blockb,mover,dire,minsize,dormb) {

 var b1,b1s,b2,b2s,tt,goo,tt2,tt3,adata,aparent,aparent2,dormbs=[] ;
 var dormb_full=95, dormb_small=60 ;                      //default values for rmb resizing
 var dormbSeveral=0;

  blocka=jQuery.trim(blocka); blockb=jQuery.trim(blockb);
  mover=jQuery.trim(mover); dire=jQuery.trim(dire);
  minsize=parseInt(minsize);

  if (arguments.length<4) dire='V';
  if (arguments.length<5 || isNaN(minsize) ) minsize=50;

// dormb init
  if (arguments.length<6 ) {
      dormb='1';
  } else {
     if (typeof(dormb)=='object' ) {
        if (dormb.length<2) wsurvey.resizer.abort(' dormb as an array must have at least two elements: '+dormb);
        if (dormb.length<3)  {
           dormb_full=parseInt(dormb[0]);
           dormb_small=parseInt(dormb[1]);
           dormb='1';
        } else {
           dormbSeveral=dormb.length ;
           dormbs=dormb;
           dormb='1';
        }
     } else {                // not an array... either on (using default) or off
        dormb=jQuery.trim(dormb);
        if (dormb!=='0')  dormb='1';
     }
  }        // dormb init


  b1=jQuery.trim(blocka.replace(/[\s,\#]+/g,' ')); b1s=b1.split(' ');
  goo='#'+b1s.join(',#');

  tt=jQuery(goo);
  if (tt.length!==b1s.length) wsurvey.resizer.abort(tt.length+': one or more of the of the '+b1s.length+' blockA ids is missing: '+b1);

  b2=jQuery.trim(blockb.replace(/[\s,\#]+/g,' ')); b2s=b2.split(' ');
  goo='#'+b2s.join(',#');

  tt2=jQuery(goo);
  if (tt2.length!==b2s.length) wsurvey.resizer.abort(tt2.length+': one or more of the of the '+b2s.length+' blockB ids is missing: '+b2);

  let moverX  = (mover.substr(0,1)=='#') ? mover : '#'+mover ;
  tt3=jQuery(moverX);

  if (tt3.length!==1)   wsurvey.resizer.abort('no such mover id (or more than one): '+mover);

  tt3.data('atMax',0);  // signals "maximized with dblclick
  tt3.data('firstSize',-1);  // signals "maximized with dblclick
  tt3.data('hasCustomEvent',1) ;
  tt3.data('dormb',dormb) ;
  tt3.data('minsize',minsize) ;
  tt3.data('dormb_small',dormb_small) ;          // these are set to defaults even if dormb=0 (so resize_custom will work with dormb option
  tt3.data('dormb_full',dormb_full) ;
  tt3.data('dormb_several',dormbSeveral);
  tt3.data('dormbs',dormbs);

  aparent=tt.parent();
  aparent2=tt2.parent();
  if (aparent[0]!==aparent2[0]) wsurvey.resizer.abort(' resizer detected blocks with different parents :: parent ids : blocka='+aparent.attr('id')+' and blockb='+aparent2.attr('id'));

  dire=dire.substr(0,1).toUpperCase(); if (dire!=='H') dire='V';
  adata={'dire':dire,'blocka':tt,'blockb':tt2,'mover':tt3,'min':minsize,'aparent':aparent,'dormb_several':dormbSeveral,'dormbs':dormbs,'minsize':minsize} ;

   tt3.oncontextmenu=function() {this.preventDefault();return false} ;

  tt3.on('mousedown',adata,wsurvey.resizer.doAreaResizer);        // this starts the "resizing"
  tt3.on('custom',adata,wsurvey.resizer.doAreaResizer);        // used by resizer_custom

 return 1 ;
}          // end of wsurvey.resizer.init


//==========================
// custom control
wsurvey.resizer.custom=function(amover,aoptions) {
   var  tt1,tt2,tt3;
  tt3=jQuery('#'+amover);
  if (tt3.length==0)   wsurvey.resizer.abort('Error in resizer_custom: no such element '+amover);
  if (typeof(tt3.data('hasCustomEvent'))=='undefined')    wsurvey.resizer.abort('Error in resizer_custom: element is not a resizer bar: '+amover);
  tt3.trigger('custom',aoptions);     // expand email list and quick viewer  when quick viewing an email    -- but leave as is if already "full expanded"

return 1;

}     // end of wsurvey.resizer.custom


//============
// resize the vuPopinbox components  -- this "starts" the resizing (on a mousedown)
wsurvey.resizer.doAreaResizer=function(evt,param1) {

  var z,atY ,qq0,qq0Height,qq1,qq1Height,jj,j;
  var adata,adire,blocka,blockb,mover,qq0Size,qq1Size,at1 ,aparent;

  adata=evt.data;
  adire=adata.dire ;
  blocka=adata.blocka ;
  blockb=adata.blockb ;
  aparent=adata.aparent;
  mover=adata.mover ;
  minsize=adata.min;

  if (evt.type.toUpperCase()=='CUSTOM') {        // rmb on "mover" bar )
      wsurvey.resizer.doAreaResizerCustom(adata,param1);    // param1 set by trigger
      return ;
  }

  if (evt.which==3 ) {        // rmb on "mover" bar )
      if (typeof(mover.data('dormb'))=='undefined' || mover.data('dormb')!=='1') return 0 ;  // rmb not enbled, so ignore
      param1={'dormb':1} ;
      wsurvey.resizer.doAreaResizerCustom(adata,param1);    // param1 set by trigger
      return ;
  }

// if more than one block use max size
  qq0Size=0; qq1Size=0;
  if (adire=='V') {
     at1=evt.pageY ;
     for (j=0;j<blocka.length;j++) {qq0Size=Math.max(qq0Size,jQuery(blocka[j]).height()) };
     for (j=0;j<blockb.length;j++) {qq1Size=Math.max(qq1Size,jQuery(blockb[j]).height()) };
  } else {
     at1=evt.pageX ;
     for (j=0;j<blocka.length;j++) {qq0Size=Math.max(qq0Size,jQuery(blocka[j]).width()) };
     for (j=0;j<blockb.length;j++) {qq1Size=Math.max(qq1Size,jQuery(blockb[j]).width()) };
  }
  mover.data('wasAt',at1);       // this is used to smooth out movements  (store in "data" attributes of the mover bar)

  // enable mouse detection on entire body. Detection disabled after mouseup

  adata={'dire':adire,'blocka':blocka,'blockb':blockb,'mover':mover,'min':minsize,'oldloc':at1,'sizea':qq0Size,'sizeb':qq1Size,'aparent':aparent} ;

  jQuery('body').on('mousemove',adata,wsurvey.resizer.doAreaResizer2);
  jQuery('body').on('mouseup',adata,wsurvey.resizer.doAreaResizer2);

  blocka.css('MozUserSelect','none');   // reduce unwanted "selection" of text
  blockb.css('MozUserSelect','none');   // reduce unwanted "selection" of text
  mover.css('MozUserSelect','none');

}   // wsurvey.resizer.doAreaResizer

wsurvey.resizer.doAreaResizer2=function(evt) {
  var pwidth,pheight,t1,t2,adata,adire,blocka,blockb,mover,aparent;
  var wasAt,oldloc,amin,amove,topHeight,bottomHeight,leftWidth,rightWidth;

  adata=evt.data ;
  adire=adata.dire ;
  blocka=adata.blocka ;
  blockb=adata.blockb ;
  mover=adata.mover ;
  aparent=adata.aparent ;


  if (evt.type=='mouseup')    {  // done -- disable mouseup, etc
    jQuery('body').off('mousemove');
    blocka.css('MozUserSelect','');
    blockb.css('MozUserSelect','');
    mover.css('MozUserSelect','');
    return 1;
  }

  if (adire=='V') {
     at2=evt.pageY ;
  } else {
    at2=evt.pageX ;
  }

   wasAt=mover.data('wasAt');
   if (Math.abs(at2-wasAt)<4) return 1 ;     // ignore small moves
   mover.data('wasAt',at2);             //  update wasAt location
   oldloc=adata.oldloc;
   amove=at2-oldloc ;   // + movements mean move down or move right
   amin=adata.min;

  if (adire=='V') {
     pheight=aparent.height();
     topHeight=adata.sizea+amove;
     bottomHeight=adata.sizeb-amove;
     if (topHeight<amin || bottomHeight<amin ) return 1 ;  // too small, ignore
     t1=Math.ceil(100*topHeight/pheight);
     blocka.css('height',t1+'%');             // set to % to  allow for clean resizing
     t2=Math.ceil(100*bottomHeight/pheight);
     blockb.css('height',t2+'%');

  } else {

     pwidth=aparent.width();
     leftWidth=adata.sizea+amove;
     rightWidth=adata.sizeb-amove;
     if (leftWidth<amin || rightWidth<amin ) return 1 ;  // too small, ignore
     t1=Math.ceil(99*leftWidth/pwidth);       // avoid odd problems by setting total width=99%
     t2=Math.ceil(99*rightWidth/pwidth);
     blocka.css('width',t1+'%');
     blockb.css('width',t2+'%');

  }
   mover.data('atMax',0);                     // any move means not maximized

  return 1;


}   // end of  wsurvey.resizer.doAreaResizer2

//=======================
// used if rmb on mover buttonm, and rmb enabled in resizer_init ; or  if  resizer_custom called (with  parameters)
// p1 is an optional associative array with variable-value pairs (set in resizer_custom call)
//   p1['firstSizePct']  : if specified, sets the sizes of the top and bottom (or left right)
//                    its value should be percent (i.e.; '60' means 60%) of the container, that the first box (the top or the left)
//                    will have as a size. The other size gets the remainder
//   p1['firstSizeHold']  : if 1, do NOT do firstSizePct if current "atMax". Otherwise, do it
//   p1['dormb']  : if 1, simulates a rmb click (which will toggle expand/shrink of left & right boxes)
// Maybe later will have other options.

wsurvey.resizer.doAreaResizerCustom=function(adata,p1) {
  var pwidth,pheight,t1,t2,adata,adire,blocka,blockb,mover,aparent;
  var wasAt,oldloc,amin,amove,topHeight,bottomHeight,leftWidth,rightWidth;
  var firstsize=-1,atmax=0,fullsize=95,smallsize=60;
  var pstart,prate,usepct,minsize,size1,size2,size1pct,size2pct,iat=0;

  adire=adata.dire ;
  blocka=adata.blocka ;
  blockb=adata.blockb ;
  mover=adata.mover ;
  aparent=adata.aparent ;
  minsize=adata.minsize ;

  var dormb_several=adata.dormb_several
  var dormbs=adata.dormbs ;
// RMB event

  if (typeof(p1['dormb'])!=='undefined' && p1['dormb']==1) {               // rmb detected

//--- array of sizes
   if (dormb_several>0) {                  // several sizes
      if (typeof(mover.data('dormbIndex'))=='undefined') {
         iat=0;
      } else {
          iat=mover.data('dormbIndex');
      }
      iat++ ;
      if (iat>=dormb_several) iat=0;
      mover.data('dormbIndex',iat);                     // save currently used index
      usepct=jQuery.trim(dormbs[iat]);

   } else {    // -- just 2 sizes (older method)
       if (typeof(mover.data('atMax'))=='undefined') return 0  ;     //atMax not initialized, so ignore (no other rmb actions currently supported
       atMax=mover.data('atMax');                   // current state (0 means NOT maximized)
       minsize=mover.data('minsize');
       if (atMax==1) {
           usepct=mover.data('dormb_small');          // maximized, so shrink  to small  (might actually be a shrink)
           mover.data('atMax',0);                     // reset
       } else {
           usepct=mover.data('dormb_full');           // not maximized, expand to full
           mover.data('atMax',1);
       }
   }    // dormb_serveral
   document.oncontextmenu=function() { return false} ;          // suppress rmb context menu whilst resizing...

   usepct=parseInt(usepct);                       // shouldn't be necessary...
   if (usepct>95) usepct=95 ;     if (usepct<5) usepct=5 ; // force in between 5 and 95

   if (adire=='V') {              // starting dimension
          pstart=aparent.height() ;   prate=0;
   } else {
          pstart=aparent.width() ;   prate=1 ;            // avoid some glitches
   }
   size1=Math.ceil( (pstart-minsize/4) *usepct/100);   // respect minsize a bit

   size2=(pstart-minsize/4)-size1;
   size1pct=Math.ceil(100*size1/pstart)-prate ;   size2pct=Math.ceil(100*size2/pstart)-prate;
   if (adire=='V') {              // starting dimension
      blocka.css('height',size1pct+'%');             // set to % to  allow for clean resizing
      blockb.css('height',size2pct+'%');
   } else {
      blocka.css('width',size1pct+'%');             // set to % to  allow for clean resizing
      blockb.css('width',size2pct+'%');
   }

   setTimeout(function(){document.oncontextmenu=function() { return true}},1000) ;   // reset contextmenus to work
   return 1;
 }        // rmb detected


//  ------------  Custom event!
  if (typeof(p1)=='undefined')  wsurvey.resizer.abort("Error in custom_resizer: no parameter argument specified ");

  amin=mover.data('minsize');
  atMax=mover.data('atMax') ;                   // current state (0 means NOT maximized)

  if (typeof(p1['firstSizePct'])=='number') {
       firstsize=parseInt(trim(p1['firstSizePct']));
       if (firstsize>95) firstsize=95 ;   // force in between 5 and 95
       if (firstsize<5) firstsize=5 ;
  }


  if (atMax==1 && firstsize>-1 && typeof(p1['firstSizeHold'])=='number') {   // if maximized by rmb, check for firstSize suppression
    if (p1['firstSizeHold']==1)  return 1;  // maximized, so do nothing
  }
  document.oncontextmenu=function() { return false} ;          // suppress rmb context menu whilst resizing...
  if (adire=='V') {
      pheight=aparent.height();
      topHeight=Math.ceil((pheight-amin/2)*(firstsize/100));
      bottomHeight=pheight-topHeight ;
      mover.data('atMax',0) ;                   // current state (0 means NOT maximized)
      t1=Math.ceil(100*topHeight/pheight);

      blocka.each(function(i1,q1) {  jQuery(q1).css('height',t1+'%') });   // overkill, but tried to fix bug (didn't work :< )
      t2=Math.ceil(100*bottomHeight/pheight);
      blockb.each(function(i1,q1) { jQuery(q1).css('height',t2+'%') });

   } else {   // H

      pwidth=aparent.width();
      leftWidth=Math.ceil((pwidth-amin/2)*(firstsize/100));
      rightWidth=(pwidth-leftWidth)   ;
      mover.data('atMax',0) ;                   // current state (0 means NOT maximized)
      t1=Math.ceil(97*leftWidth/pwidth);       // avoid odd problems by setting total width=97%
      t2=Math.ceil(97*rightWidth/pwidth);
      blocka.each(function(i1,q1) {  jQuery(q1).css('width',t1+'%') });
      blockb.each(function(i1,q1) {  jQuery(q1).css('width',t2+'%') });


  }
  mover.data('atMax',0);                     // any move means not maximized

  setTimeout(function(){document.oncontextmenu=function() { return true}},1000) ;   // reset contextmenus to work

  return 1;

}    // end of     wsurvey.resizer.doAreaResizerCustom

//============
// error handler
wsurvey.resizer.abort=function(amess,quiet) {
   if (arguments.length<2) quiet=0 ;
    if (quiet!=1) alert(amess);
    console.trace(amess);
    throw 'wsurvey.resizer error ';
    return 0 ;
}        // end of wsurvey.resizer.abort
