<?php
ob_start();
// Demo the wSurvey file upload functions.
//

// Load uploadFiles.php -- be sure that $getit is the absolution location of  wsurvey.uploadFiles.php
 $acurdir=getcwd();
 $libdir=dirname($acurdir);                  // in non-demo code, set $getit to be wherever you stored  wsurvey.uploadFiles.php
 $getit=$libdir.'/php/wsurvey.uploadFiles.php';
 require_once($getit);

// Not necessary, but a useful double check. Overflow (content-length > max) can have undesirable effects!

 wsurvey\uploadFiles\checkOverflow(1) ;     // 1 means "exit if overflow".

// ............
// Check for $_REQUEST variables. If none, display html with file upload elements, etc.

// The 'wsurvey_uploadFiles_action'  $_REQUEST variable is  special:
//    Specifically: wsurvey.uploadFiles.submit.echoback() sets wsurvey_uploadFiles_action='echoback'
//                wsurvey.uploadFiles.submit.upload sets wsurvey_uploadFiles_action='upload'
//
// And, since custom requests are specified below, also check for  'custom'  $_REQUEST variable

// Presumably, when a request is recieved, the server will do something interesting with the uploaded files.
// But for this demo, just report on what was recieved by the server

 $todo=wsurvey\uploadFiles\extractRequestVar('wsurvey_uploadFiles_action',1);

 $acustom=wsurvey\uploadFiles\extractRequestVar('custom',0);   // is this a "direct call" (that specified extra fields)
 $pieces=wsurvey\uploadFiles\extractRequestVar('pieces',0);   // upload in pieces?

  if ($acustom==1) {   // a custom (direct) call
     $astuff=wsurvey\uploadFiles\retrieve(1);
     $atime=wsurvey\uploadFiles\extractRequestVar('timeStamp','n.a.');
     $adate=date('d/M/Y h:i:s ',$atime/1000);
     $nowDate=date('d/M/Y h:i:s ',$atime/1000);
     $foo= $_SERVER['CONTENT_LENGTH'];
     print "Recieved ".count($astuff)." files  | sent @ $adate, receieved @ $nowDate (size of requrest=$foo) ";
     exit;
  }

// not a "custom" call  -- a request from .upload() or .echoback() ?
 if ($todo=='upload') {  // recieving a bunch of file info. Just echo it back as is to prove it worked
    $astuff=wsurvey\uploadFiles\retrieve(1);
    if ($pieces==0) {
        print " Response from server: the structure of the uploaded fileData  (".count($astuff)." files) ";
        print '<p>';
        var_dump($astuff);
    } else {              // upload in pieces 
        $oof=$astuff[0];
        print $oof['fileName'].' ('.$oof['fileSize'].')  || <span title="comment"><em> '.$oof['comment'].'</em></span>' ;
    }
    exit;
 }   // example of upload


// This is all that is needed to echoback an uploaded file (or files)
// Alternate: use the wsurvey.uploadFiles.echoback.php as the pathPhp in setup()
 if ($todo=='echoback') {
     ob_clean();
     $astuff0=wsurvey\uploadFiles\echoBack(0);    // echo  -- if multiple files, sends back a .zip
     exit;
 }   // echo file(s)


// ========= end of php


?>
<!DOCTYPE html>
<html><head>
<meta charset="utf-8">
<title>Test wsurvey.uploadFiles </title>

<style type="text/css">
/* these classes are used in this demo script. They are not required */
.infoDisplay {
   font-size:80%;
   max-height:15em;
   min-height:7em;
   overflow:
   auto;border:2px dotted gray;
}
.dropZoneC {
  border:2px solid blue;
  width: 200px;
  height: 100px;
  opacity:0.5;
}
.cshow0 {
  margin:10px 5% 10px 5%;
  border:1px solid red;
  auto;height:10em;
  overflow:auto;
}
.cshow01 {
  margin:10px 5% 10px 5%;
  border:1px solid cyan;
  height:15em;
  overflow:auto;
}
.cshow1 {
   margin:10px 5% 10px 5%;
   border:1px solid blue;
   auto;height:10em;
   overflow:auto;
}

</style>

<!-- set these scripts to wherever you stored your .js libraries .... -->

<script type="text/javascript" src="../publicLib/jquery-3.6.0.min.js"></script>
<script type="text/javascript" src=" ../js/wsurvey.utils1.js"></script>
<script type="text/javascript" src="../js/wsurvey.uploadFiles.js"></script>

<script type="text/javascript">

window.onload=init1 ;

<?php
// server memory limits written here (as js globals). Using this, in a <script> BEFORE calling .setup(), is RECOMMENDED.
  wsurvey\uploadFiles\readSizeLimits(1);
?>

//=======================
//  Supported fields in opts:
//     button drop textarea
//     submit  echoback
//     summary clear
//     maxFiles upload_max_filesize  post_max_size   memory_limit
//     pathPhp  pathPhpEchoback callback callbackClear
//     echoback_auto upload_auto
// If an option is not specified, defaults are used

function init1(i) {

   $('#saveSummary').on('click',saveTextToFile);  // add this "custom" action

// setup uploadFies. Note use of the "default" uploadDataName ('1')

   let opts={ 'button':'inputFiles',  'drop':'drop_zone', 'textarea':'saveTextArea',
              'submit':'uploadSubmit',  'echoback':'uploadEchoback',
              'summary':'files_toServer_info', 'clear':'clearAll',
              'callback':'sendStatus', 'callbackClear':'clearCustom', 'pathPhp':'', 'pathPhpEchoback':'',
              'echoback_auto':'textarea', 'upload_auto':''
            }
// Notes: 'echoback_auto':'textarea'  is not typical (it is specified to demonstrate auto-echoback)
//         callbackClear is a nicety, but does not effect wsurvey.uploadFiles performance.
//        pathPhpEchoback and pathPhp do not need to be specified in thise demo (since the defaults are '')
//        callbackClear and callback can be specified as actual function references, or as the string name of the function

   wsurvey.uploadFiles.setup(1,opts) ;             // Note .setup() will clear all uploadFiles data (to avoid problems from quick reloads)

}


//=====
// These "custom" functions are used in some of the demo buttons below. They are not required
//

// ===================================
// read info, and contents, of  files chosen for upload
// This is strictly used for status and testing.  In normal file uploads, you don't have to supply this kind of function
function viewEm(i) {

 let stuff= wsurvey.uploadFiles.getUploadData(1 );     // retrieve current info on files to upload

 let stuffT= wsurvey.uploadFiles.uploadDataField(stuff,'*' );     // retrieve summary current info on files to upload

 let say1='<pre>'+ wsurvey.dumpObj(stuffT,'var','Summary of information on chosen files:')+'</pre>';

 let vmess=['Encoded: <tt>crc32, name, mimetype, size, date, dataType, base64EncodedContent (might also be uriEncoded)</tt>'];
 for (var m1=0;m1<stuff['fileData'].length;m1++) {
      let  aff=stuff['fileData'][m1];
      let aid=aff['id'];
      ilen = (aff['fileLen']<10000) ?  aff['fileLen'] :(aff['fileLen']/1000).toFixed(1)+'k' ;
      let bmess='Internal id <tt>'+aid+'</tt>. <u>'+aff['fileName']+'</u> (<tt>'+ilen+' </tt> ';
      bmess+= '<span style="font-style:oblique;font-size:90%">'+aff['comment']+'</span>) ';
      bmess+='<span style="white-space:pre;font-size:80%">'+aff['content'].substr(0,130)+'</span>';
      if (aff['content'].length>130) bmess+=' &hellip; ';
      vmess.push(bmess);
 }
 let vmessSay=vmess.join('<li>');
 say1=say1+' <hr width="50%"> <ul style="list-style:square"><li>'+vmessSay+'</ul>';

  $('#show0').html(say1);            // parse out raw stuff and show its fields



 let astuff= wsurvey.uploadFiles.unpackFileData(stuff);     // unpack (encoded) file specs

 let  zz1='';

  for (jj=0;jj<astuff.length;jj++) {
   aa1=astuff[jj];
   zz1+='<hr width="30%"> <ul><li>name: '+aa1.fileName+'<li>Size: '+aa1.fileSize+'<li>type: '+aa1.fileType+'<li>mod date '+aa1.fileDate ;
   let cc1=wsurvey.htmlspecialchars(aa1.fileContent);
   let dd1='<div  class="viewEm1">'+cc1+'</div>';

   zz1+='<li> content: '+dd1;
   zz1+='</ul>';
  }
  $('#show01').html(zz1);            // parse out raw stuff and show its fields
   return 1;
}

//==================
// select which files to remove, and change comments
// Display a menu of currently selected files -- allow for "removal" and "change comments"
function selectEm(athis) {

 let stuff0= wsurvey.uploadFiles.getUploadData(1  );     // retrieve current info on files to upload
 let fileList=wsurvey.uploadFiles.unpackFileData(stuff0);

  let amess='<div name="selectEm_top"><b>Remove entries, and modify comments</b>';
  amess+='<input type="button" value="make the changes" onClick="selectEm2(this)"> ';
  amess+='<table rules="rows" cellpadding="4"><tr><td>Remove</td><td>fileName</td><td>length</td> <td>comment ..</td></tr>';
  for (var a1 in fileList ) {
     var arow=fileList[a1];
     amess+='<tr><td><input type="checkbox" value="1" title="Check to remove this file upload"  data-id="'+arow['rowId'] +'" name="selectEmRemove">';
     amess+='<td><tt>'+arow['fileName']+'</tt></td>';
     amess+='<td><span style="font-size:80%">'+arow['fileSize']+'</span></td>';
     amess+='<td><input type="text" name="selectEmComment" value="'+arow['comment']+'" data-orig="'+arow['comment']+'" size="90"></td>';
     amess+='</tr>';
  }
  amess+='</table></div>';

  $('#show01').html(amess);
}
// processs choices made in the menu crated by selectEm
function selectEm2(athis) {
    let ethis=wsurvey.argJquery(athis);
    let eparent=ethis.closest('[name="selectEm_top"]');
    let eremoves=eparent.find('[name="selectEmRemove"]');

// which rows to remove, and which comments to modify
    let doRemoves={},doComments={};
    for (var kk=0;kk<eremoves.length;kk++) {
        let aremove=$(eremoves[kk]);
        let aid=aremove.attr('data-id');
        if (aremove.prop('checked')) doRemoves[aid]=1;

        let trparent=aremove.closest('tr');
        let ecomment=trparent.find('[name="selectEmComment"]');
        let nowComment=ecomment.val();
        let wascomment=ecomment.attr('data-orig');
        if (nowComment!=wascomment) doComments[aid]=nowComment;
    }

   let fileListNew=[];   // this is created using the above: to remove rows, and change comments

   let stuff0 = wsurvey.uploadFiles.getUploadData(1  );     // retrieve current info on files to upload
   let fileList=wsurvey.uploadFiles.unpackFileData(stuff0);

// remove, or modify comments
   for (var i1=0;i1<fileList.length;i1++){
       let astuff=fileList[i1];
       let sid=astuff['rowId'];
       if (doRemoves.hasOwnProperty(sid)) continue ;  // remove this
       let new1=astuff;
       if (doComments.hasOwnProperty(sid)) new1['comment']=doComments[sid];
       fileListNew.push(new1);
   }

// convert "unpacked" format to 'packed' format
   fileListPacked=wsurvey.uploadFiles.packFileData(fileListNew );  // convert

// and save packed fromat to the upload data
    wsurvey.uploadFiles.updateFileData(1,fileListPacked);   // save to data storate

  viewEm(1);   // show new file info

 wsurvey.uploadFiles.updateSummary(1,fileListNew) ;  // maybe update summary

  return 1;

}

//================
// clear the 'custom' display containers.
// This is used in the callbackClear option
function clearCustom(athis) {

   $('#show0').html('');
   $('#show01').html('');
   $('#show1').html('');

   let ethis=wsurvey.argJquery(athis);
   let iclears=ethis.attr('data-clears');
   iclears++;
   ethis.attr('data-clears',iclears);
   if (iclears>1)  ethis.css({'color':'red'});

   return 1;
}

//===============
//  A direct clear (not manipulated by .setup())
// This  demonstrates direct calls to  wsurvey.uploadFiles.submit.clear
function clearIt(which) {
   if (which==1)   {  // clear data
      wsurvey.uploadFiles.submit.clear(1,false);  // 1=use the uploadDataName, false means "do not call the callback_clear
   }
   if (which==2) {
      $('#show0').html('');
      $('#show01').html('');
      $('#show1').html('');
   }
}
//==========================
// sample callback (when upload button is hit).  It is the value of the callback option
//  It will process the response returned by the server
function sendStatus(adata,fileData,tstatus,ajx) {
    $('#show1').html('Return status: '+tstatus+'<br>Content:<pre>'+ (adata)+'</pre>');

  let arf= $('#show1').offset();
  $('html, body').scrollTop(arf.top);
}

//==============
// save the content of the 'show0' container
// Upopn upload (or echoback), it is uploaded to the server (as if it were a file upload)
//
function saveTextToFile(athis) {
    let etext=$('#show0');
    let atext=etext.html();
    let acache=wsurvey.uploadFiles.textUpload(1,atext,'text/plain') ;
}

//==============
// demonstrate directall to wsurvey.uploadFiles.submit.upload
// which= 1 : use default uploadDataName,
// which==2 : echoback using 'wsurvey.uploadFiles.echoback.php

function uploadIt(iwhich) {
   if (iwhich==1)   {  // an upload using uploadit2 as the callback
     let extraFields={'timeStamp':Date.now(),'custom':1} ;
     let myopts={'pathPhp':null,'callback':uploadit2,'addFields':extraFields};
     wsurvey.uploadFiles.submit.upload(1,myopts,'simple example of otherInfo');
     return 1;
   }
// else, use wsurvey.uploadFiles.echoBack.php as the php script
// Notes:
//    * submit.echoback() does NOT use a callback  -- since the point is to be a simple way of saving content to a local file)
//   *  wsurvey.uploadFiles.echoback.php will look for a 'which' $_REQUEST var -- 0 means "return as zip", >0 means "return nth file"

   let myopts={'pathPhpEchoback':'wsurvey.uploadFiles.echoback.php','which':iwhich};
 //  wsurvey.dumpObj(myopts,1,'for echoback ');
   wsurvey.uploadFiles.submit.echoback(1,myopts);

}

// callbacks are called using : (data,stuff,tstatus,ajx)
//  data: resposne from server
//  stuff : contents of the uploadData (object with event handlers, file data, etc)
//  tstatus: status (from server)
//  xhr : jqXHR (from server)

function uploadit2(adata,stuff,tstatus,xhr,otherInfo) {
   let goo=' Response from :<u>upload using simple callback</u> (<em>'+otherInfo+'</em>)<br> ...Fields in uploadData:<div style="font-size:80%"> ' ;
   for (var a in stuff) goo+=' | '+a+' ('+typeof(stuff[a])+') ';
   goo+='</div> Response from server:<tt> '+adata+'<tt>' ;
   let goo2= wsurvey.dumpObj(xhr,'var','tstatus ='+tstatus);
   goo+='<hr width="30%">server xhr : <pre>'+goo2+'</pre>';
   $('#show1').html(goo);
}


//==================
// upload file list one-at-atime
function uploadInPieces(athis) {

   let astuff=wsurvey.uploadFiles.getUploadData(1,'uploadInPieces') ;   // just used to report total #files to be processed
   let nFiles=wsurvey.uploadFiles.uploadDataField(astuff,'nfiles');

   let ethis=wsurvey.argJquery(athis);
   let adelay=ethis.wsurvey_attr("data-delay,delay",100);  // delay in milliseconds between uploads

   let opts={'callback':uploadInPiecesShow,'delay':adelay,'addFields':{'pieces':1}};
   let otherInfo={} ;

// header for the upload in pieces status report
   let amess='<b>Upload in pieces status: </b>'
   amess+='<span id="oneAt_pause_span"  ><input type="checkbox" value="1" id="oneAt_pause"><label title="click to pause one-at-time uploads" for="oneAt_pause">Pause</label> </span> &boxV; ';
   amess+='<span id="oneAt_stop_span"  > <input type="checkbox" value="1" id="oneAt_stop"><label title="click to stop one-at-time uploads" for="oneAt_stop">Stop</label> </span> ';
   amess+='<span id="oneAt_resume_span" style="display:none"> &boxV;  ';
   amess+='<input value="resume" type="button" value="1" id="oneAt_resume" data-controlvarname="" ';
   amess+= '      onclick="uploadInPiecesResume(this)" ';
   amess+='     title="click to resume one-at-time uploads" for="oneAt_stop"></span> ';

   amess+='<br>';
   amess+='<div name="uploadInPieces"><em>Number of files to upload</em> = <tt>'+nFiles+'</tt> ';
   amess+'<em>Now uploading ...  </em> <span name="uploadInPiecesNext">1</span> ';
   amess+='<ol name="uploadInPieceUl"> ';
   amess+='</ol>';
   amess+='</div>';
   $("#show1").html(amess);
   let arf= $('#show1').offset();
  $('html, body').scrollTop(arf.top);

   wsurvey.uploadFiles.submit.uploadInPieces(1,opts,otherInfo); // start uploading in pieces
}


//============
// call back for one at a time
function uploadInPiecesShow(response,stuff,tstatus,xhr,otherInfo) {

   let justDone=otherInfo['wsurveyUploadFiles_nextDo'] ;
   let nTodo=otherInfo['wsurveyUploadFiles_nTodo'] ;

   let ssid=$('#show1');
   let enext=ssid.find('[name="uploadInPiecesNext"]');
   enext.html(justDone+1);

   let ulid=ssid.find('[name="uploadInPieceUl"]');
   ulid.append('<li> Just completed: '+response);
   if (justDone==nTodo-1)  {
       ulid.append('<li> All done.');
       return 1;
   }

// check controls
  let ec1=$('#oneAt_pause');
  let ev1=ec1.prop('checked');
  if (ev1) {         // pause is checked
     ulid.append('<li> Pausing ...');

    let ec1a=$('#oneAt_pause_span');
    ec1a.css({'opacity':0.5});
    $('#oneAt_resume_span').show();
    let controlVarName= otherInfo['wsurveyUploadFiles_control']  ;
     wsurvey.uploadFiles.submit.uploadInPieces_control('pause',stuff,otherInfo);
     return 1;
  }

  let ec2=$('#oneAt_stop');
  let ev2=ec2.prop('checked');
  if (ev2) {         // stop is checked
     ulid.append('<li> Upload aborted  ...');
     wsurvey.uploadFiles.submit.uploadInPieces_control('stop',stuff,otherInfo);
     return 1;
  }

   return 1;
}

//==========
// resume one at a time
function uploadInPiecesResume(athis) {
   var ethis=wsurvey.argJquery(athis);
   var cvar=ethis.wsurvey_attr('data-controlvarname',1);

    let ec1a=$('#oneAt_pause_span');
    ec1a.css({'opacity':1});
    $('#oneAt_resume_span').hide();
    let ec1b=$('#oneAt_pause');
    ec1b.prop('checked',false);

   let ssid=$('#show1');
   let ulid=ssid.find('[name="uploadInPieceUl"]');
   ulid.append('<li> Upload resumed ');


   wsurvey.uploadFiles.submit.uploadInPieces_control('resume',1);
   return 1;
}

</script>

<!-- :::::::::::::: begin body ++++++++++++++++++++ -->

<body  >

  <h3>Demo of wsurvey.uploadFile functions</h3>

<!-- file selection (input, dropzone, and textrea) and currently selected files summary-display area -->

 <table cellpadding="5" style="border:1px solid gray" >
 <tr>
   <td>                                                              <!-- add to uploads: input type="file" method -->
   <em>Choose file(s) to upload ...</em> </td>
   <td>   <input type="file" title="Chose  files to upload"   multiple="multiple"  id="inputFiles"  >   </td>
   <td>
      <div id="files_toServer_info" class="infoDisplay">  </div>     <!-- summary of selected files displayed here -->
   </td>
   <td>                                                              <!--add to uploads: drag and drop zone   -->
      <div id="drop_zone"  class="dropZoneC" > Drag one or more files to this Drop Zone ... </div>
   </td>
   <td bgcolor="gray">                                               <!-- add to uploads:  content of textarea method -->
     <em>Enter text to save-as-file</em> and then <input type="button" id="saveTextArea" value="Echoback all files, and this text.."  >
     <em> as .. </em>
      <input id="textAreaEntry" title="how to save -- enter a mimetype. Blank for `application/octet-stream` (generic binary)"
              value="text/plain" size="15" type="text" >
     <br>
     <textarea id="textStuff" rows="5" cols="70"  style="white-space:pre">enter text here </textarea>
 </td>
</tr>
</table>

<!-- control buttons ... -->
  <input type="button" id="uploadSubmit" value="Upload the files!"   >  or
  <input type="button" id="uploadEchoback" value="Echoback the file(s)" title="... if multiple files, echo back a zip file"> &hellip;
  <input type="button" value="ClearAll"    id="clearAll">   &nbsp;   &boxV; ... </em>other controls</em>

  <input type="button" value="Clear fileData"   onclick="clearIt(1)" >  &nbsp;
  <input type="button" value="Clear results"    onclick="clearIt(2)">
  <input type="button" value="Upload w/ simple callback "  onclick="uploadIt(1)">
  <input type="button" value="Echoback 2nd file" title="This  uses wsurvey.uploadFiles.echoback.php "  onclick="uploadIt(2)">
 &boxV;
  <input type="button" value="Upload in pieces" title="One file at a time " data-delay="600" onclick="uploadInPieces(this)">


<!-- status and results ..... -->

<hr>
<span style="font-weight:800">Files-to-be-uploaded: </span>
  <input type="button" value="view current summary" onClick="viewEm(1)">  &nbsp;
  <input id="saveSummary" type="button" value="Upload this summary  "   >            <!--add to uploads:  custom string -->

<div id="show0"  class="cshow0" >raw stuff here </div>

<hr>
<b>javascript unpack results here: </b>, <em>or ... </em> 
<input type="button" value="Remove and modify " onclick="selectEm(this)"  >
<div id="show01" class="cshow01" >unpack stuff here (content to be sent)</div>

<hr>
<h4>Server response after <tt>Upload the files!</tt> </h4>
<div id="show1" class="cshow1">php stuff here  (response from server)</div>


</body>


</html>
